/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAction;
import org.noos.xing.mydoggy.plaf.actions.PlafToolWindowAction;
import org.noos.xing.mydoggy.plaf.ui.util.DynamicPropertyChangeListener;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class MaximizeToolWindowAction
extends ToolWindowAction
implements PlafToolWindowAction {
    protected PropertyChangeListener propertyChangeListener;

    public MaximizeToolWindowAction() {
        super("MAXIMIZE_ACTION_ID", UIManager.getIcon("ToolWindowTitleButtonPanelUI.icon.maximize.inactive"));
        this.setTooltipText(SwingUtil.getString("@@tool.tooltip.maximize"));
        this.putValue("constraint", 1);
    }

    public void setToolWindow(ToolWindow toolWindow) {
        if (toolWindow == null) {
            this.toolWindow.addPropertyChangeListener("maximized", this.propertyChangeListener);
            this.toolWindow.addPropertyChangeListener("active", this.propertyChangeListener);
            this.propertyChangeListener = null;
            super.setToolWindow(toolWindow);
        } else {
            super.setToolWindow(toolWindow);
            this.propertyChangeListener = new PropertyListener();
            this.setActionName("toolWindow.maximizeButton." + toolWindow.getId());
            toolWindow.addPropertyChangeListener("maximized", this.propertyChangeListener);
            toolWindow.addPropertyChangeListener("active", this.propertyChangeListener);
        }
    }

    public JMenuItem getMenuItem() {
        if (this.menuItem == null) {
            this.menuItem = new JMenuItem();
            this.menuItem.setText(SwingUtil.getString("@@tool.maximize"));
            this.menuItem.setActionCommand("menu.maximize");
            this.menuItem.addActionListener(this);
        }
        this.menuItem.setVisible(this.toolWindow.isVisible());
        this.menuItem.setText(this.toolWindow.isMaximized() ? SwingUtil.getString("@@tool.maximize.restore") : SwingUtil.getString("@@tool.maximize"));
        return this.menuItem;
    }

    public void actionPerformed(ActionEvent e) {
        this.toolWindow.setActive(true);
        this.toolWindow.setMaximized(!this.toolWindow.isMaximized());
    }

    public class PropertyListener
    extends DynamicPropertyChangeListener {
        private boolean flag = false;

        public void onMaximized(PropertyChangeEvent evt) {
            if (((Boolean)evt.getNewValue()).booleanValue()) {
                MaximizeToolWindowAction.this.setIcon(UIManager.getIcon("ToolWindowTitleButtonPanelUI.icon.minimize"));
                MaximizeToolWindowAction.this.putValue("ShortDescription", SwingUtil.getString("@@tool.tooltip.restore"));
                this.flag = true;
            } else if (this.flag) {
                MaximizeToolWindowAction.this.setIcon(UIManager.getIcon("ToolWindowTitleButtonPanelUI.icon.maximize"));
                MaximizeToolWindowAction.this.putValue("ShortDescription", SwingUtil.getString("@@tool.tooltip.maximize"));
                this.flag = false;
            }
        }

        public void onActive(PropertyChangeEvent evt) {
            boolean active = (Boolean)evt.getNewValue();
            if (active) {
                if (MaximizeToolWindowAction.this.toolWindow.isMaximized()) {
                    MaximizeToolWindowAction.this.setIcon(UIManager.getIcon("ToolWindowTitleButtonPanelUI.icon.minimize"));
                } else {
                    MaximizeToolWindowAction.this.setIcon(UIManager.getIcon("ToolWindowTitleButtonPanelUI.icon.maximize"));
                }
            } else if (MaximizeToolWindowAction.this.toolWindow.isMaximized()) {
                MaximizeToolWindowAction.this.setIcon(UIManager.getIcon("ToolWindowTitleButtonPanelUI.icon.minimize.inactive"));
            } else {
                MaximizeToolWindowAction.this.setIcon(UIManager.getIcon("ToolWindowTitleButtonPanelUI.icon.maximize.inactive"));
            }
        }
    }
}

