/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.onewire;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import nl.lxtreme.ols.api.UserSettings;
import nl.lxtreme.ols.api.tools.Tool;
import nl.lxtreme.ols.api.tools.ToolContext;
import nl.lxtreme.ols.api.tools.ToolTask;
import nl.lxtreme.ols.api.util.UnitOfTime;
import nl.lxtreme.ols.tool.base.BaseToolDialog;
import nl.lxtreme.ols.tool.base.ExportAware;
import nl.lxtreme.ols.tool.base.ToolDialog;
import nl.lxtreme.ols.tool.base.ToolUtils;
import nl.lxtreme.ols.tool.onewire.OneWireAnalyser;
import nl.lxtreme.ols.tool.onewire.OneWireAnalyserTask;
import nl.lxtreme.ols.tool.onewire.OneWireBusMode;
import nl.lxtreme.ols.tool.onewire.OneWireData;
import nl.lxtreme.ols.tool.onewire.OneWireDataSet;
import nl.lxtreme.ols.util.ExportUtils;
import nl.lxtreme.ols.util.HostUtils;
import nl.lxtreme.ols.util.StringUtils;
import nl.lxtreme.ols.util.swing.SpringLayoutUtils;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;
import org.osgi.framework.BundleContext;

public class OneWireAnalyserDialog
extends BaseToolDialog<OneWireDataSet>
implements ExportAware<OneWireDataSet> {
    private static final long serialVersionUID = 1L;
    private JComboBox owLine;
    private JComboBox owMode;
    private JEditorPane outText;
    private ToolUtils.RestorableAction runAnalysisAction;
    private Action exportAction;
    private Action closeAction;

    public OneWireAnalyserDialog(Window aOwner, ToolContext aToolContext, BundleContext aContext, OneWireAnalyser aTool) {
        super(aOwner, aToolContext, aContext, (Tool)aTool);
        this.initDialog();
        this.setLocationRelativeTo(this.getOwner());
    }

    public void exportToFile(File aOutputFile, ExportAware.ExportFormat aFormat) throws IOException {
        OneWireDataSet lastResult = (OneWireDataSet)((Object)this.getLastResult());
        if (ExportAware.ExportFormat.HTML.equals((Object)aFormat)) {
            this.toHtmlPage(aOutputFile, lastResult);
        } else if (ExportAware.ExportFormat.CSV.equals((Object)aFormat)) {
            // empty if block
        }
    }

    public void readPreferences(UserSettings aSettings) {
        this.setComboBoxIndex(this.owLine, aSettings, "owLine");
        this.owMode.setSelectedIndex(aSettings.getInt("owMode", this.owMode.getSelectedIndex()));
    }

    public void reset() {
        String emptyHtmlPage = this.getEmptyHtmlPage();
        this.outText.setText(emptyHtmlPage);
        this.outText.setEditable(false);
        this.runAnalysisAction.restore();
        this.setControlsEnabled(true);
        this.exportAction.setEnabled(false);
    }

    public void writePreferences(UserSettings aSettings) {
        aSettings.putInt("owLine", this.owLine.getSelectedIndex());
        aSettings.putInt("owMode", this.owMode.getSelectedIndex());
    }

    protected void onToolEnded(OneWireDataSet aResult) {
        block2: {
            try {
                String htmlPage = aResult != null ? this.toHtmlPage(null, aResult) : this.getEmptyHtmlPage();
                this.outText.setText(htmlPage);
                this.outText.setEditable(false);
                this.runAnalysisAction.restore();
            }
            catch (IOException exception) {
                if (HostUtils.handleInterruptedException((Throwable)exception)) break block2;
                throw new RuntimeException(exception);
            }
        }
    }

    protected void onToolStarted() {
    }

    protected void prepareToolTask(ToolTask<OneWireDataSet> aToolTask) {
        OneWireAnalyserTask toolTask = (OneWireAnalyserTask)aToolTask;
        toolTask.setOneWireLineIndex(this.owLine.getSelectedIndex());
        toolTask.setOneWireBusMode(this.owMode.getSelectedIndex() == 0 ? OneWireBusMode.STANDARD : OneWireBusMode.OVERDRIVE);
    }

    protected void setControlsEnabled(boolean aEnabled) {
        this.owLine.setEnabled(aEnabled);
        this.owMode.setEnabled(aEnabled);
        this.closeAction.setEnabled(aEnabled);
        this.exportAction.setEnabled(aEnabled);
    }

    private ExportUtils.HtmlExporter createHtmlTemplate(ExportUtils.HtmlExporter aExporter) {
        aExporter.addCssStyle("body { font-family: sans-serif; } ");
        aExporter.addCssStyle("table { border-width: 1px; border-spacing: 0px; border-color: gray; border-collapse: collapse; border-style: solid; margin-bottom: 15px; } ");
        aExporter.addCssStyle("table th { border-width: 1px; padding: 2px; border-style: solid; border-color: gray; background-color: #C0C0FF; text-align: left; font-weight: bold; font-family: sans-serif; } ");
        aExporter.addCssStyle("table td { border-width: 1px; padding: 2px; border-style: solid; border-color: gray; font-family: monospace; } ");
        aExporter.addCssStyle(".date { text-align: right; font-size: x-small; margin-bottom: 15px; } ");
        aExporter.addCssStyle(".w100 { width: 100%; } ");
        aExporter.addCssStyle(".w30 { width: 30%; } ");
        aExporter.addCssStyle(".w20 { width: 20%; } ");
        aExporter.addCssStyle(".w15 { width: 15%; } ");
        aExporter.addCssStyle(".w10 { width: 10%; } ");
        ExportUtils.HtmlExporter.Element body = aExporter.getBody();
        body.addChild(ExportUtils.HtmlExporter.H1).addContent(new String[]{"1-Wire&reg; Analysis results"});
        body.addChild(ExportUtils.HtmlExporter.HR);
        body.addChild(ExportUtils.HtmlExporter.DIV).addAttribute("class", "date").addContent(new String[]{"{date-now}"});
        ExportUtils.HtmlExporter.Element table = body.addChild(ExportUtils.HtmlExporter.TABLE).addAttribute("class", "w100");
        ExportUtils.HtmlExporter.Element tbody = table.addChild(ExportUtils.HtmlExporter.TBODY);
        ExportUtils.HtmlExporter.Element tr = tbody.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("colspan", "2").addContent(new String[]{"Statistics"});
        tr = tbody.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TD).addAttribute("class", "w30").addContent(new String[]{"Decoded bytes"});
        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"{decoded-bytes}"});
        tr = tbody.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TD).addAttribute("class", "w30").addContent(new String[]{"Detected bus errors"});
        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"{detected-bus-errors}"});
        table = body.addChild(ExportUtils.HtmlExporter.TABLE).addAttribute("class", "w100");
        ExportUtils.HtmlExporter.Element thead = table.addChild(ExportUtils.HtmlExporter.THEAD);
        tr = thead.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w30").addContent(new String[]{"Index"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w15").addContent(new String[]{"Time"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w20").addContent(new String[]{"Hex"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w20").addContent(new String[]{"Bin"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w20").addContent(new String[]{"Dec"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w10").addContent(new String[]{"ASCII"});
        tbody = table.addChild(ExportUtils.HtmlExporter.TBODY);
        tbody.addContent(new String[]{"{decoded-data}"});
        return aExporter;
    }

    private JPanel createPreviewPane() {
        JPanel output = new JPanel(new GridLayout(1, 1, 0, 0));
        this.outText = new JEditorPane("text/html", this.getEmptyHtmlPage());
        this.outText.setEditable(false);
        output.add(new JScrollPane(this.outText));
        return output;
    }

    private JComponent createSettingsPane() {
        int channelCount = this.getData().getChannels();
        String[] modes = new String[]{"Standard", "Overdrive"};
        JPanel panel = new JPanel(new SpringLayout());
        SpringLayoutUtils.addSeparator((Container)panel, (String)"Settings");
        panel.add(SwingComponentUtils.createRightAlignedLabel((String)"1-Wire Line"));
        this.owLine = SwingComponentUtils.createChannelSelector((int)channelCount, (int)0);
        panel.add(this.owLine);
        panel.add(SwingComponentUtils.createRightAlignedLabel((String)"Bus Mode"));
        this.owMode = new JComboBox<String>(modes);
        this.owMode.setSelectedIndex(0);
        panel.add(this.owMode);
        SpringLayoutUtils.makeEditorGrid((Container)panel, (int)10, (int)4);
        return panel;
    }

    private String getEmptyHtmlPage() {
        ExportUtils.HtmlExporter exporter = this.createHtmlTemplate(ExportUtils.createHtmlExporter());
        return exporter.toString(new ExportUtils.HtmlExporter.MacroResolver(){

            public Object resolve(String aMacro, ExportUtils.HtmlExporter.Element aParent) {
                if ("date-now".equals(aMacro)) {
                    DateFormat df = DateFormat.getDateInstance(1);
                    return df.format(new Date());
                }
                if ("sda-bus-config".equals(aMacro) || "scl-bus-config".equals(aMacro)) {
                    return "&lt;auto detect&gt;";
                }
                if ("decoded-bytes".equals(aMacro) || "detected-bus-errors".equals(aMacro)) {
                    return "-";
                }
                return null;
            }
        });
    }

    private void initDialog() {
        this.setMinimumSize(new Dimension(640, 480));
        JComponent settingsPane = this.createSettingsPane();
        JPanel previewPane = this.createPreviewPane();
        JPanel contentPane = new JPanel(new GridBagLayout());
        contentPane.add((Component)settingsPane, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(2, 0, 2, 0), 0, 0));
        contentPane.add((Component)previewPane, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 0, 2, 0), 0, 0));
        JButton runAnalysisButton = ToolUtils.createRunAnalysisButton((ToolDialog)this);
        this.runAnalysisAction = (ToolUtils.RestorableAction)runAnalysisButton.getAction();
        JButton exportButton = ToolUtils.createExportButton((ExportAware)this);
        this.exportAction = exportButton.getAction();
        this.exportAction.setEnabled(false);
        JButton closeButton = ToolUtils.createCloseButton();
        this.closeAction = closeButton.getAction();
        JComponent buttonPane = SwingComponentUtils.createButtonPane((JButton[])new JButton[]{runAnalysisButton, exportButton, closeButton});
        SwingComponentUtils.setupDialogContentPane((JDialog)((Object)this), (Component)contentPane, (Component)buttonPane, (JButton)runAnalysisButton);
        this.pack();
    }

    private String toHtmlPage(File aFile, final OneWireDataSet aAnalysisResult) throws IOException {
        ExportUtils.HtmlExporter.MacroResolver macroResolver = new ExportUtils.HtmlExporter.MacroResolver(){

            public Object resolve(String aMacro, ExportUtils.HtmlExporter.Element aParent) {
                if ("date-now".equals(aMacro)) {
                    DateFormat df = DateFormat.getDateInstance(1);
                    return df.format(new Date());
                }
                if ("decoded-bytes".equals(aMacro)) {
                    return aAnalysisResult.getDecodedByteCount();
                }
                if ("detected-bus-errors".equals(aMacro)) {
                    return aAnalysisResult.getBusErrorCount();
                }
                if ("decoded-data".equals(aMacro)) {
                    List dataSet = aAnalysisResult.getData();
                    for (int i = 0; i < dataSet.size(); ++i) {
                        ExportUtils.HtmlExporter.Element tr;
                        OneWireData data = (OneWireData)((Object)dataSet.get(i));
                        if (data.isEvent()) {
                            String event = data.getEventName();
                            String bgColor = "RESET".equals(event) ? "#e0e0e0" : "#ff8000";
                            tr = aParent.addChild(ExportUtils.HtmlExporter.TR).addAttribute("style", "background-color: " + bgColor + ";");
                            tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{String.valueOf(i)});
                            tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{UnitOfTime.format((double)aAnalysisResult.getTime(data.getStartSampleIndex()))});
                            tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{event});
                            tr.addChild(ExportUtils.HtmlExporter.TD);
                            tr.addChild(ExportUtils.HtmlExporter.TD);
                            tr.addChild(ExportUtils.HtmlExporter.TD);
                            continue;
                        }
                        int value = data.getValue();
                        tr = aParent.addChild(ExportUtils.HtmlExporter.TR);
                        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{String.valueOf(i)});
                        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{UnitOfTime.format((double)aAnalysisResult.getTime(data.getStartSampleIndex()))});
                        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"0x" + StringUtils.integerToHexString((int)value, (int)2)});
                        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"0b" + StringUtils.integerToBinString((int)value, (int)8)});
                        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{String.valueOf(value)});
                        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{String.valueOf((char)value)});
                    }
                }
                return null;
            }
        };
        if (aFile == null) {
            ExportUtils.HtmlExporter exporter = this.createHtmlTemplate(ExportUtils.createHtmlExporter());
            return exporter.toString(macroResolver);
        }
        ExportUtils.HtmlFileExporter exporter = (ExportUtils.HtmlFileExporter)this.createHtmlTemplate((ExportUtils.HtmlExporter)ExportUtils.createHtmlExporter((File)aFile));
        exporter.write(macroResolver);
        exporter.close();
        return null;
    }
}

