/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.prefs.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.felix.prefs.BackingStoreManager;
import org.apache.felix.prefs.PreferencesDescription;
import org.apache.felix.prefs.PreferencesImpl;
import org.apache.felix.prefs.impl.StreamBackingStoreImpl;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class DataFileBackingStoreImpl
extends StreamBackingStoreImpl {
    protected final File rootDirectory;

    public DataFileBackingStoreImpl(BundleContext context) {
        super(context);
        this.rootDirectory = context.getDataFile("");
    }

    protected void checkAccess() throws BackingStoreException {
        if (this.rootDirectory == null) {
            throw new BackingStoreException("Saving of data files to the bundle context is currently not supported.");
        }
    }

    protected OutputStream getOutputStream(PreferencesDescription desc) throws IOException {
        File file = this.getFile(desc);
        return new FileOutputStream(file);
    }

    public Long[] availableBundles() {
        try {
            this.checkAccess();
        }
        catch (BackingStoreException ignore) {
            return new Long[0];
        }
        HashSet<Long> bundleIds = new HashSet<Long>();
        File[] children = this.rootDirectory.listFiles();
        for (int i = 0; i < children.length; ++i) {
            File current = children[i];
            PreferencesDescription desc = this.getDescription(current);
            if (desc == null) continue;
            bundleIds.add(desc.getBundleId());
        }
        return bundleIds.toArray(new Long[bundleIds.size()]);
    }

    protected PreferencesDescription getDescription(File file) {
        String fileName = file.getName();
        if (fileName.startsWith("P") && fileName.endsWith(".ser")) {
            String key;
            String identifier;
            String name = fileName.substring(1, fileName.length() - 4);
            int pos = name.indexOf("_");
            if (pos != -1) {
                identifier = name.substring(pos + 1);
                key = name.substring(0, pos);
            } else {
                key = name;
                identifier = null;
            }
            Long bundleId = Long.valueOf(key);
            return new PreferencesDescription(bundleId, identifier);
        }
        return null;
    }

    public void remove(Long bundleId) throws BackingStoreException {
        this.checkAccess();
        File[] children = this.rootDirectory.listFiles();
        for (int i = 0; i < children.length; ++i) {
            File current = children[i];
            PreferencesDescription desc = this.getDescription(current);
            if (desc == null || !desc.getBundleId().equals(bundleId)) continue;
            current.delete();
        }
    }

    public PreferencesImpl[] loadAll(BackingStoreManager manager, Long bundleId) throws BackingStoreException {
        this.checkAccess();
        ArrayList<PreferencesImpl> list = new ArrayList<PreferencesImpl>();
        File[] children = this.rootDirectory.listFiles();
        for (int i = 0; i < children.length; ++i) {
            File current = children[i];
            PreferencesDescription desc = this.getDescription(current);
            if (desc == null || !desc.getBundleId().equals(bundleId)) continue;
            PreferencesImpl root = new PreferencesImpl(desc, manager);
            try {
                FileInputStream fis = new FileInputStream(current);
                this.read(root, fis);
                fis.close();
            }
            catch (IOException ioe) {
                throw new BackingStoreException("Unable to load preferences.", ioe);
            }
            list.add(root);
        }
        return list.toArray(new PreferencesImpl[list.size()]);
    }

    public PreferencesImpl load(BackingStoreManager manager, PreferencesDescription desc) throws BackingStoreException {
        this.checkAccess();
        File file = this.getFile(desc);
        if (file.exists()) {
            try {
                PreferencesImpl root = new PreferencesImpl(desc, manager);
                FileInputStream fis = new FileInputStream(file);
                this.read(root, fis);
                fis.close();
                return root;
            }
            catch (IOException ioe) {
                throw new BackingStoreException("Unable to load preferences.", ioe);
            }
        }
        return null;
    }

    protected File getFile(PreferencesDescription desc) {
        StringBuffer buffer = new StringBuffer("P");
        buffer.append(desc.getBundleId());
        if (desc.getIdentifier() != null) {
            buffer.append('_');
            buffer.append(desc.getIdentifier());
        }
        buffer.append(".ser");
        File file = new File(this.rootDirectory, buffer.toString());
        return file;
    }
}

