/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.project.impl;

import java.awt.Color;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import nl.lxtreme.ols.api.UserSettings;
import nl.lxtreme.ols.util.ColorUtils;

public class UserSettingsImpl
implements UserSettings {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Properties properties;

    public UserSettingsImpl(String aName) {
        this(aName, new Properties());
    }

    public UserSettingsImpl(String aName, Properties aProperties) {
        if (aName == null) {
            throw new IllegalArgumentException("Name cannot be null!");
        }
        if (aProperties == null) {
            throw new IllegalArgumentException("Properties cannot be null!");
        }
        this.name = aName;
        this.properties = (Properties)aProperties.clone();
    }

    protected UserSettingsImpl(UserSettings aSettings) {
        if (aSettings == null) {
            throw new IllegalArgumentException("Settings cannot be null!");
        }
        this.name = aSettings.getName();
        if (aSettings instanceof UserSettingsImpl) {
            this.properties = (Properties)((UserSettingsImpl)aSettings).getProperties().clone();
        } else {
            this.properties = new Properties();
            for (Map.Entry entry : aSettings) {
                this.properties.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public String get(String aName, String aDefaultValue) {
        String result = this.properties.getProperty(aName, aDefaultValue);
        return result;
    }

    public boolean getBoolean(String aName, boolean aDefaultValue) {
        String value = this.properties.getProperty(aName);
        if (value == null) {
            return aDefaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public int getInt(String aName, int aDefaultValue) {
        String value = this.properties.getProperty(aName);
        if (value == null) {
            return aDefaultValue;
        }
        return Integer.parseInt(value);
    }

    public long getLong(String aName, long aDefaultValue) {
        String value = this.properties.getProperty(aName);
        if (value == null) {
            return aDefaultValue;
        }
        return Long.parseLong(value);
    }

    public String getName() {
        return this.name;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Iterator<Map.Entry<String, Object>> iterator() {
        return new UserSettingsIterator(this.properties);
    }

    public void put(String aName, String aValue) {
        this.properties.put(aName, aValue);
    }

    public void putAll(Map<?, ?> aSettings) {
        this.properties.putAll(aSettings);
    }

    public void putBoolean(String aName, boolean aValue) {
        this.properties.put(aName, Boolean.toString(aValue));
    }

    public void putInt(String aName, int aValue) {
        this.properties.put(aName, Integer.toString(aValue));
    }

    public void putLong(String aName, long aValue) {
        this.properties.put(aName, Long.toString(aValue));
    }

    protected void delete(String aName) {
        this.properties.remove(aName);
    }

    protected Color getColor(String aName, Color aDefaultValue) {
        String value = this.properties.getProperty(aName);
        if (value == null) {
            return aDefaultValue;
        }
        return ColorUtils.parseColor((String)value);
    }

    protected <T extends Enum<T>> T getEnumValue(String aName, T aDefault) {
        String value = this.properties.getProperty(aName);
        if (value == null) {
            return aDefault;
        }
        return (T)Enum.valueOf(aDefault.getClass(), value);
    }

    protected void putColor(String aName, Color aValue) {
        if (aValue == null) {
            throw new IllegalArgumentException("Color cannot be null! Use delete() method to delete a key-value pair!");
        }
        String hexString = ColorUtils.toHexString((Color)aValue);
        this.properties.put(aName, hexString);
    }

    protected <T extends Enum<T>> void putEnumValue(String aName, T aValue) {
        if (aValue == null) {
            throw new IllegalArgumentException("Enum cannot be null! Use delete() method to delete a key-value pair!");
        }
        this.properties.put(aName, aValue.name());
    }

    static final class UserSettingsIterator
    implements Iterator<Map.Entry<String, Object>> {
        private final Iterator<Map.Entry<Object, Object>> entries;

        public UserSettingsIterator(Properties aProperties) {
            this.entries = aProperties.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.entries.hasNext();
        }

        @Override
        public Map.Entry<String, Object> next() {
            Map.Entry<Object, Object> nextEntry = this.entries.next();
            String key = String.valueOf(nextEntry.getKey());
            Object value = nextEntry.getValue();
            return new AbstractMap.SimpleImmutableEntry<String, Object>(key, value);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

