/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.util.swing.component;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.LinkedList;
import java.util.List;

public class StackLayout
implements LayoutManager2 {
    public static final String BOTTOM = "bottom";
    public static final String TOP = "top";
    private final List<Component> components = new LinkedList<Component>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component aComp, Object aConstraints) {
        Object object = aComp.getTreeLock();
        synchronized (object) {
            if (BOTTOM.equals(aConstraints)) {
                this.components.add(0, aComp);
            } else {
                this.components.add(aComp);
            }
        }
    }

    @Override
    public void addLayoutComponent(String aName, Component aComponent) {
        this.addLayoutComponent(aComponent, TOP);
    }

    @Override
    public float getLayoutAlignmentX(Container aTarget) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container aTarget) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container aTarget) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container aParent) {
        Object object = aParent.getTreeLock();
        synchronized (object) {
            int width = aParent.getWidth();
            int height = aParent.getHeight();
            Rectangle bounds = new Rectangle(0, 0, width, height);
            int componentsCount = this.components.size();
            for (int i = 0; i < componentsCount; ++i) {
                Component comp = this.components.get(i);
                comp.setBounds(bounds);
                aParent.setComponentZOrder(comp, componentsCount - i - 1);
            }
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container aTarget) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container aParent) {
        Object object = aParent.getTreeLock();
        synchronized (object) {
            int width = 0;
            int height = 0;
            for (Component comp : this.components) {
                Dimension size = comp.getMinimumSize();
                width = Math.max(size.width, width);
                height = Math.max(size.height, height);
            }
            Insets insets = aParent.getInsets();
            return new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container aParent) {
        Object object = aParent.getTreeLock();
        synchronized (object) {
            int width = 0;
            int height = 0;
            for (Component comp : this.components) {
                Dimension size = comp.getPreferredSize();
                width = Math.max(size.width, width);
                height = Math.max(size.height, height);
            }
            Insets insets = aParent.getInsets();
            return new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component aComponent) {
        Object object = aComponent.getTreeLock();
        synchronized (object) {
            this.components.remove(aComponent);
        }
    }
}

