/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.util;

import java.awt.Color;

public final class ColorUtils {
    private ColorUtils() {
    }

    public static Color getContrastColor(Color aColor) {
        double pl = 1.0 - ColorUtils.getPerceivedLuminance(aColor);
        if (pl < 0.5) {
            return Color.BLACK;
        }
        return Color.WHITE;
    }

    public static Color getHighlightColor(Color aColor, float aFactor) {
        float[] hsb = Color.RGBtoHSB(aColor.getRed(), aColor.getGreen(), aColor.getBlue(), null);
        hsb[2] = Math.min(1.0f, hsb[2] * aFactor);
        return new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
    }

    public static double getPerceivedLuminance(Color aColor) {
        float[] rgb = aColor.getRGBComponents(null);
        return 0.299 * (double)rgb[0] + 0.587 * (double)rgb[1] + 0.114 * (double)rgb[2];
    }

    public static double getStandardLuminance(Color aColor) {
        float[] rgb = aColor.getRGBComponents(null);
        return 0.2126 * (double)rgb[0] + 0.7152 * (double)rgb[1] + 0.0722 * (double)rgb[2];
    }

    public static Color interpolate(Color aBaseColor, Color aSecondaryColor, float aDelta) {
        float[] acomp = aSecondaryColor.getRGBComponents(null);
        float[] bcomp = aBaseColor.getRGBComponents(null);
        float[] ccomp = new float[4];
        for (int i = 0; i < 4; ++i) {
            ccomp[i] = acomp[i] + (bcomp[i] - acomp[i]) * aDelta;
        }
        return new Color(ccomp[0], ccomp[1], ccomp[2], ccomp[3]);
    }

    public static final Color parseColor(String aColor) {
        if (aColor == null) {
            throw new IllegalArgumentException("Color cannot be null!");
        }
        String color = aColor.trim();
        if (color.startsWith("#")) {
            color = color.substring(1);
        }
        try {
            int colorValue = Integer.parseInt(color, 16);
            return new Color(colorValue >> 16 & 0xFF, colorValue >> 8 & 0xFF, colorValue & 0xFF);
        }
        catch (NumberFormatException exception) {
            throw new IllegalArgumentException("Given string does NOT represent a valid color!");
        }
    }

    public static String toHexString(Color aColor) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%02x", aColor.getRed()));
        sb.append(String.format("%02x", aColor.getGreen()));
        sb.append(String.format("%02x", aColor.getBlue()));
        return sb.toString();
    }
}

