/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.uart.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.Edge;
import nl.lxtreme.ols.api.data.annotation.Annotation;
import nl.lxtreme.ols.api.data.annotation.AnnotationListener;
import nl.lxtreme.ols.api.tools.ToolContext;
import nl.lxtreme.ols.api.tools.ToolProgressListener;
import nl.lxtreme.ols.api.tools.ToolTask;
import nl.lxtreme.ols.tool.base.annotation.ChannelLabelAnnotation;
import nl.lxtreme.ols.tool.base.annotation.SampleDataAnnotation;
import nl.lxtreme.ols.tool.uart.AsyncSerialDataDecoder;
import nl.lxtreme.ols.tool.uart.BaudRateAnalyzer;
import nl.lxtreme.ols.tool.uart.impl.UARTDataSet;
import nl.lxtreme.ols.util.NumberUtils;

public class UARTAnalyserTask
implements ToolTask<UARTDataSet> {
    private static final Logger LOG = Logger.getLogger(UARTAnalyserTask.class.getName());
    public static final int AUTO_DETECT_BAUDRATE = -1;
    private final ToolContext context;
    private final ToolProgressListener progressListener;
    private final AnnotationListener annotationListener;
    private int rxdIndex;
    private int txdIndex;
    private int ctsIndex;
    private int rtsIndex;
    private int dcdIndex;
    private int riIndex;
    private int dsrIndex;
    private int dtrIndex;
    private boolean inverted;
    private boolean inversed;
    private AsyncSerialDataDecoder.StopBits stopBits;
    private AsyncSerialDataDecoder.Parity parity;
    private int bitCount;
    private int baudRate;

    public UARTAnalyserTask(ToolContext aContext, ToolProgressListener aProgressListener, AnnotationListener aAnnotationListener) {
        this.context = aContext;
        this.progressListener = aProgressListener;
        this.annotationListener = aAnnotationListener;
        this.rxdIndex = -1;
        this.txdIndex = -1;
        this.ctsIndex = -1;
        this.rtsIndex = -1;
        this.dcdIndex = -1;
        this.riIndex = -1;
        this.dsrIndex = -1;
        this.dtrIndex = -1;
        this.baudRate = -1;
    }

    public UARTDataSet call() throws Exception {
        AcquisitionResult data = this.context.getData();
        int[] values = data.getValues();
        int startOfDecode = this.context.getStartSampleIndex();
        int endOfDecode = this.context.getEndSampleIndex();
        int mask = this.getBitMask();
        int value = values[startOfDecode] & mask;
        for (int i = startOfDecode + 1; i < endOfDecode; ++i) {
            if (value == (values[i] & mask)) continue;
            startOfDecode = i;
            break;
        }
        if ((startOfDecode = Math.max(0, startOfDecode - 10)) >= endOfDecode) {
            LOG.log(Level.WARNING, "No valid data range found for UART analysis! Analysis aborted...");
            throw new IllegalStateException("No valid data range found for UART analysis!");
        }
        UARTDataSet decodedData = new UARTDataSet(startOfDecode, endOfDecode, data);
        if (this.rxdIndex >= 0) {
            this.prepareAndDecodeData(decodedData, this.rxdIndex, 3, "RxD");
        }
        if (this.txdIndex >= 0) {
            this.prepareAndDecodeData(decodedData, this.txdIndex, 4, "TxD");
        }
        if (this.ctsIndex >= 0) {
            this.prepareAndDecodeControl(decodedData, this.ctsIndex, "CTS");
        }
        if (this.rtsIndex >= 0) {
            this.prepareAndDecodeControl(decodedData, this.rtsIndex, "RTS");
        }
        if (this.dcdIndex >= 0) {
            this.prepareAndDecodeControl(decodedData, this.dcdIndex, "DCD");
        }
        if (this.riIndex >= 0) {
            this.prepareAndDecodeControl(decodedData, this.riIndex, "RI");
        }
        if (this.dsrIndex >= 0) {
            this.prepareAndDecodeControl(decodedData, this.dsrIndex, "DSR");
        }
        if (this.dtrIndex >= 0) {
            this.prepareAndDecodeControl(decodedData, this.dtrIndex, "DTR");
        }
        decodedData.sort();
        return decodedData;
    }

    public boolean isInversed() {
        return this.inversed;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setBaudRate(int aBaudRate) {
        this.baudRate = aBaudRate;
    }

    public void setBitCount(int aBitCount) {
        this.bitCount = aBitCount;
    }

    public void setCtsIndex(int aCtsIndex) {
        this.ctsIndex = aCtsIndex;
    }

    public void setDcdIndex(int aDcdIndex) {
        this.dcdIndex = aDcdIndex;
    }

    public void setDsrIndex(int aDsrIndex) {
        this.dsrIndex = aDsrIndex;
    }

    public void setDtrIndex(int aDtrIndex) {
        this.dtrIndex = aDtrIndex;
    }

    public void setInversed(boolean aInversed) {
        this.inversed = aInversed;
    }

    public void setInverted(boolean aInverted) {
        this.inverted = aInverted;
    }

    public void setParity(AsyncSerialDataDecoder.Parity aParity) {
        this.parity = aParity;
    }

    public void setRiIndex(int aRiIndex) {
        this.riIndex = aRiIndex;
    }

    public void setRtsIndex(int aRtsIndex) {
        this.rtsIndex = aRtsIndex;
    }

    public void setRxdIndex(int aRxdIndex) {
        this.rxdIndex = aRxdIndex;
    }

    public void setStopBits(AsyncSerialDataDecoder.StopBits aStopBits) {
        this.stopBits = aStopBits;
    }

    public void setTxdIndex(int aTxdIndex) {
        this.txdIndex = aTxdIndex;
    }

    private void addSymbolAnnotation(int aChannelIndex, int aSymbol, long aStartTimestamp, long aEndTimestamp) {
        this.annotationListener.onAnnotation((Annotation)new SampleDataAnnotation(aChannelIndex, aStartTimestamp, aEndTimestamp, String.format("0x%1$X (%1$c)", aSymbol)));
    }

    private BaudRateAnalyzer createBaudRateAnalyzer(AcquisitionResult aData, int aMask) {
        if (this.baudRate == -1) {
            return new BaudRateAnalyzer(aData.getSampleRate(), aData.getValues(), aData.getTimestamps(), aMask);
        }
        return new BaudRateAnalyzer(aData.getSampleRate(), this.baudRate);
    }

    private void decodeControl(UARTDataSet aDataSet, int aChannelIndex, String aName) {
        AcquisitionResult data = this.context.getData();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Decoding control: {0} ...", aName);
        }
        int mask = 1 << aChannelIndex;
        int startSampleIdx = aDataSet.getStartOfDecode();
        int endSampleIdx = aDataSet.getEndOfDecode();
        int[] values = data.getValues();
        this.progressListener.setProgress(0);
        int oldValue = values[startSampleIdx] & mask;
        for (int i = startSampleIdx + 1; i < endSampleIdx; ++i) {
            int value = values[i] & mask;
            Edge edge = Edge.toEdge((int)oldValue, (int)value);
            if (edge.isRising()) {
                aDataSet.reportControlHigh(aChannelIndex, i, aName);
            }
            if (edge.isFalling()) {
                aDataSet.reportControlLow(aChannelIndex, i, aName);
            }
            oldValue = value;
            this.progressListener.setProgress(NumberUtils.getPercentage((int)i, (int)startSampleIdx, (int)endSampleIdx));
        }
    }

    private void decodeData(final UARTDataSet aDataSet, final int aChannelIndex, final int aEventType) {
        final AcquisitionResult data = this.context.getData();
        int mask = 1 << aChannelIndex;
        BaudRateAnalyzer baudrateAnalyzer = this.createBaudRateAnalyzer(data, mask);
        int bitLength = baudrateAnalyzer.getBestBitLength();
        LOG.log(Level.FINE, "Baudrate = {0}bps", bitLength);
        if (bitLength <= 0) {
            LOG.log(Level.INFO, "No (usable) {0}-data found for determining bitlength/baudrate ...", aChannelIndex == this.rxdIndex ? "RxD" : "TxD");
        } else {
            aDataSet.setSampledBitLength(bitLength);
            aDataSet.setBaudRateExact(baudrateAnalyzer.getBaudRateExact());
            aDataSet.setBaudRate(baudrateAnalyzer.getBaudRate());
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Samplerate: " + data.getSampleRate() + ", bitlength: " + bitLength + ", baudrate = " + aDataSet.getBaudRate());
            }
            AsyncSerialDataDecoder.SerialConfiguration config = new AsyncSerialDataDecoder.SerialConfiguration(baudrateAnalyzer.getBaudRateExact(), this.bitCount, this.stopBits, this.parity, this.inverted, this.inversed);
            AsyncSerialDataDecoder decoder = new AsyncSerialDataDecoder(config, this.context);
            decoder.setProgressListener(this.progressListener);
            decoder.setCallback(new AsyncSerialDataDecoder.SerialDecoderCallback(){

                @Override
                public void onError(int aChannelIdx, AsyncSerialDataDecoder.ErrorType aType, long aTime) {
                    int sampleIdx = data.getSampleIndex(aTime);
                    int eventType = aEventType == 3 ? 1 : 2;
                    aDataSet.reportError(aType, aChannelIdx, sampleIdx, eventType);
                }

                @Override
                public void onEvent(int aChannelIdx, String aEvent, long aStartTime, long aEndTime) {
                }

                @Override
                public void onSymbol(int aChannelIdx, int aSymbol, long aStartTime, long aEndTime) {
                    int startSampleIdx = Math.max(data.getSampleIndex(aStartTime), 0);
                    int endSampleIdx = Math.min(data.getSampleIndex(aEndTime), data.getTimestamps().length - 1);
                    aDataSet.reportData(aChannelIndex, startSampleIdx, endSampleIdx, aSymbol, aEventType);
                    UARTAnalyserTask.this.addSymbolAnnotation(aChannelIndex, aSymbol, aStartTime, aEndTime);
                }
            });
            decoder.decodeDataLine(aChannelIndex);
        }
    }

    private int getBitMask() {
        int mask;
        int result = 0;
        if (this.rxdIndex >= 0) {
            mask = 1 << this.rxdIndex;
            LOG.log(Level.FINE, "RxD mask = 0x{0}", Integer.toHexString(mask));
            result |= mask;
        }
        if (this.txdIndex >= 0) {
            mask = 1 << this.txdIndex;
            LOG.log(Level.FINE, "TxD mask = 0x{0}", Integer.toHexString(mask));
            result |= mask;
        }
        if (this.ctsIndex >= 0) {
            mask = 1 << this.ctsIndex;
            LOG.log(Level.FINE, "CTS mask = 0x{0}", Integer.toHexString(mask));
            result |= mask;
        }
        if (this.rtsIndex >= 0) {
            mask = 1 << this.rtsIndex;
            LOG.log(Level.FINE, "RTS mask = 0x{0}", Integer.toHexString(mask));
            result |= mask;
        }
        if (this.dcdIndex >= 0) {
            mask = 1 << this.dcdIndex;
            LOG.log(Level.FINE, "DCD mask = 0x{0}", Integer.toHexString(mask));
            result |= mask;
        }
        if (this.riIndex >= 0) {
            mask = 1 << this.riIndex;
            LOG.log(Level.FINE, "RI mask = 0x{0}", Integer.toHexString(mask));
            result |= mask;
        }
        if (this.dsrIndex >= 0) {
            mask = 1 << this.dsrIndex;
            LOG.log(Level.FINE, "DSR mask = 0x{0}", Integer.toHexString(mask));
            result |= mask;
        }
        if (this.dtrIndex >= 0) {
            mask = 1 << this.dtrIndex;
            LOG.log(Level.FINE, "DTR mask = 0x{0}", Integer.toHexString(mask));
            result |= mask;
        }
        return result;
    }

    private void prepareAndDecodeControl(UARTDataSet aDataSet, int aChannelIndex, String aDefaultLabel) {
        this.prepareResult(aChannelIndex, aDefaultLabel);
        this.decodeControl(aDataSet, aChannelIndex, aDefaultLabel);
    }

    private void prepareAndDecodeData(UARTDataSet aDataSet, int aChannelIndex, int aEventType, String aDefaultLabel) {
        this.prepareResult(aChannelIndex, aDefaultLabel);
        this.decodeData(aDataSet, aChannelIndex, aEventType);
    }

    private void prepareResult(int aChannelIndex, String aLabel) {
        this.annotationListener.clearAnnotations(aChannelIndex);
        this.annotationListener.onAnnotation((Annotation)new ChannelLabelAnnotation(aChannelIndex, aLabel));
    }
}

