/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.util.swing.component.icon;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class TextOverlayIcon
extends ImageIcon {
    private static final long serialVersionUID = 1L;

    public TextOverlayIcon(Icon aIcon, String aTextOverlay) {
        this(aIcon, aTextOverlay, 0);
    }

    public TextOverlayIcon(Icon aIcon, String aTextOverlay, int aPosition) {
        this.setImage(this.drawCompoundIcon(aIcon, aTextOverlay, aPosition));
    }

    private Shape createOutline(TextLayout aText, int aPosition, int aWidth, int aHeight) {
        float yText;
        float xText;
        Shape outline = aText.getOutline(null);
        Rectangle textBounds = outline.getBounds();
        switch (this.getHorizontalAlignment(aPosition)) {
            case 0: {
                xText = (float)((double)(aWidth - textBounds.width) / 2.0);
                break;
            }
            case 4: {
                xText = aWidth - textBounds.width - 1;
                break;
            }
            default: {
                xText = -textBounds.x;
            }
        }
        switch (this.getVerticalAlignment(aPosition)) {
            case 0: {
                yText = (float)((double)aHeight / 2.0 + (double)aText.getAscent() / 4.0);
                break;
            }
            case 3: {
                yText = aHeight - 1;
                break;
            }
            default: {
                yText = -textBounds.y;
            }
        }
        AffineTransform shift = AffineTransform.getTranslateInstance(xText - 1.0f, yText - 1.0f);
        return shift.createTransformedShape(outline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage drawCompoundIcon(Icon aIcon, String aText, int aPosition) {
        int width = aIcon.getIconWidth();
        int height = aIcon.getIconHeight();
        BufferedImage result = new BufferedImage(width, height, 2);
        Graphics2D g2d = (Graphics2D)result.getGraphics();
        try {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, 100);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            aIcon.paintIcon(null, g2d, 0, 0);
            Font textFont = new Font("Dialog", 1, 16);
            g2d.setFont(textFont);
            FontRenderContext frc = g2d.getFontRenderContext();
            TextLayout text = new TextLayout(aText, textFont, frc);
            Shape shp = this.createOutline(text, aPosition, width, height);
            g2d.setColor(Color.WHITE);
            g2d.fill(shp);
            g2d.setComposite(AlphaComposite.DstOver.derive(0.5f));
            g2d.setColor(Color.BLACK);
            g2d.draw(shp);
        }
        finally {
            g2d.dispose();
            g2d = null;
        }
        return result;
    }

    private int getHorizontalAlignment(int aPosition) {
        int result;
        switch (aPosition) {
            case 2: 
            case 3: 
            case 4: {
                result = 4;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                result = 2;
                break;
            }
            default: {
                result = 0;
            }
        }
        return result;
    }

    private int getVerticalAlignment(int aPosition) {
        int result;
        switch (aPosition) {
            case 1: 
            case 2: 
            case 8: {
                result = 1;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                result = 3;
                break;
            }
            default: {
                result = 0;
            }
        }
        return result;
    }
}

