/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.util.swing.component;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class JPopdownButton
extends JToggleButton {
    private static final long serialVersionUID = 1L;
    private final JPopupMenu popupMenu = new JPopupMenu();
    private boolean shouldHandlePopupWillBecomeInvisible = true;

    public JPopdownButton(Icon aIcon) {
        this(aIcon, aIcon);
    }

    public JPopdownButton(Icon aDefaultIcon, Icon aPressedAndSelectedIcon) {
        this.setIcon(aDefaultIcon);
        this.setPressedIcon(aPressedAndSelectedIcon);
        this.setSelectedIcon(aPressedAndSelectedIcon);
        this.setFocusable(false);
        this.putClientProperty("JButton.buttonType", "textured");
        this.addMouseListener(this.createButtonMouseListener());
        this.popupMenu.addPopupMenuListener(this.createPopupMenuListener());
        JComboBox box = new JComboBox();
        Object preventHide = box.getClientProperty("doNotCancelPopup");
        this.putClientProperty("doNotCancelPopup", preventHide);
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    private MouseListener createButtonMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (JPopdownButton.this.popupMenu.isShowing()) {
                    JPopdownButton.this.hidePopupMenu();
                } else {
                    JPopdownButton.this.showPopupMenu();
                }
            }
        };
    }

    private PopupMenuListener createPopupMenuListener() {
        return new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                JPopdownButton.this.setSelected(false);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (JPopdownButton.this.shouldHandlePopupWillBecomeInvisible) {
                    JPopdownButton.this.setSelected(false);
                }
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        };
    }

    private void hidePopupMenu() {
        this.shouldHandlePopupWillBecomeInvisible = false;
        this.popupMenu.setVisible(false);
        this.shouldHandlePopupWillBecomeInvisible = true;
    }

    private void showPopupMenu() {
        this.popupMenu.show(this, 5, this.getHeight());
    }
}

