/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.util.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.lxtreme.ols.util.ApplicationCallback;
import nl.lxtreme.ols.util.HostUtils;

public final class ApplicationCallbackFacade
implements ApplicationCallback {
    private volatile ApplicationCallback service;

    static void installApplicationCallback(ApplicationCallback aApplicationCallback) {
        block3: {
            String applicationClassName = "com.apple.eawt.Application";
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                Object aboutHandler = OSXAboutHandler.createInstance(aApplicationCallback);
                Object prefsHandler = OSXPreferencesHandler.createInstance(aApplicationCallback);
                Object quitHandler = OSXQuitHandler.createInstance(aApplicationCallback);
                Class<?> appClass = classLoader.loadClass("com.apple.eawt.Application");
                if (appClass != null) {
                    Method getAppMethod = appClass.getMethod("getApplication", new Class[0]);
                    Object app = getAppMethod.invoke(null, new Object[0]);
                    Method setAboutHandlerMethod = appClass.getMethod("setAboutHandler", OSXAboutHandler.getHandlerClass());
                    setAboutHandlerMethod.invoke(app, aboutHandler);
                    Method setPreferencesHandlerMethod = appClass.getMethod("setPreferencesHandler", OSXPreferencesHandler.getHandlerClass());
                    setPreferencesHandlerMethod.invoke(app, prefsHandler);
                    Method setQuitHandlerMethod = appClass.getMethod("setQuitHandler", OSXQuitHandler.getHandlerClass());
                    setQuitHandlerMethod.invoke(app, quitHandler);
                }
            }
            catch (Exception exception) {
                if (HostUtils.handleInterruptedException(exception)) break block3;
                Logger.getAnonymousLogger().log(Level.FINE, "Install application callback failed!", exception);
            }
        }
    }

    @Override
    public boolean handleAbout() {
        if (this.service != null) {
            return this.service.handleAbout();
        }
        return false;
    }

    @Override
    public boolean handlePreferences() {
        if (this.service != null) {
            return this.service.handlePreferences();
        }
        return false;
    }

    @Override
    public boolean handleQuit() {
        if (this.service != null) {
            return this.service.handleQuit();
        }
        return false;
    }

    @Override
    public boolean hasPreferences() {
        if (this.service != null) {
            return this.service.hasPreferences();
        }
        return false;
    }

    public void start() {
        ApplicationCallbackFacade.installApplicationCallback(this);
    }

    static class OSXQuitHandler
    implements InvocationHandler {
        private static final String QUIT_HANDLER_CLASS_NAME = "com.apple.eawt.QuitHandler";
        private final ApplicationCallback callback;

        OSXQuitHandler(ApplicationCallback aCallback) {
            this.callback = aCallback;
        }

        public static Object createInstance(ApplicationCallback aCallback) throws ClassNotFoundException {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return Proxy.newProxyInstance(classLoader, new Class[]{OSXQuitHandler.getHandlerClass()}, (InvocationHandler)new OSXQuitHandler(aCallback));
        }

        public static Class<?> getHandlerClass() throws ClassNotFoundException {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return classLoader.loadClass(QUIT_HANDLER_CLASS_NAME);
        }

        @Override
        public Object invoke(Object aProxy, Method aMethod, Object[] aArgs) throws Throwable {
            if ("handleQuitRequestWith".equals(aMethod.getName())) {
                Object quitResponseObj;
                Class<?> quitResponseClass;
                boolean confirmQuit = this.callback.handleQuit();
                if (aArgs.length > 1 && aArgs[1] != null && "com.apple.eawt.QuitResponse".equals((quitResponseClass = (quitResponseObj = aArgs[1]).getClass()).getName())) {
                    if (confirmQuit) {
                        Method performQuitMethod = quitResponseClass.getMethod("performQuit", new Class[0]);
                        performQuitMethod.invoke(quitResponseObj, new Object[0]);
                    } else {
                        Method cancelQuitMethod = quitResponseClass.getMethod("cancelQuit", new Class[0]);
                        cancelQuitMethod.invoke(quitResponseObj, new Object[0]);
                    }
                }
            }
            return null;
        }
    }

    static class OSXPreferencesHandler
    implements InvocationHandler {
        private static final String PREFS_HANDLER_CLASS_NAME = "com.apple.eawt.PreferencesHandler";
        private final ApplicationCallback callback;

        OSXPreferencesHandler(ApplicationCallback aCallback) {
            this.callback = aCallback;
        }

        public static Object createInstance(ApplicationCallback aCallback) throws ClassNotFoundException {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return Proxy.newProxyInstance(classLoader, new Class[]{OSXPreferencesHandler.getHandlerClass()}, (InvocationHandler)new OSXPreferencesHandler(aCallback));
        }

        public static Class<?> getHandlerClass() throws ClassNotFoundException {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return classLoader.loadClass(PREFS_HANDLER_CLASS_NAME);
        }

        @Override
        public Object invoke(Object aProxy, Method aMethod, Object[] aArgs) throws Throwable {
            if ("handlePreferences".equals(aMethod.getName())) {
                this.callback.handlePreferences();
            }
            return null;
        }
    }

    static class OSXAboutHandler
    implements InvocationHandler {
        private static final String ABOUT_HANDLER_CLASS_NAME = "com.apple.eawt.AboutHandler";
        private final ApplicationCallback callback;

        OSXAboutHandler(ApplicationCallback aCallback) {
            this.callback = aCallback;
        }

        public static Object createInstance(ApplicationCallback aCallback) throws ClassNotFoundException {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return Proxy.newProxyInstance(classLoader, new Class[]{OSXAboutHandler.getHandlerClass()}, (InvocationHandler)new OSXAboutHandler(aCallback));
        }

        public static Class<?> getHandlerClass() throws ClassNotFoundException {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return classLoader.loadClass(ABOUT_HANDLER_CLASS_NAME);
        }

        @Override
        public Object invoke(Object aProxy, Method aMethod, Object[] aArgs) throws Throwable {
            if ("handleAbout".equals(aMethod.getName())) {
                this.callback.handleAbout();
            }
            return null;
        }
    }
}

