/*
 * Decompiled with CFR 0.152.
 */
package org.sump.device.logicsniffer.sampleprocessor;

import java.util.logging.Logger;
import org.sump.device.logicsniffer.LogicSnifferConfig;
import org.sump.device.logicsniffer.sampleprocessor.SampleProcessor;
import org.sump.device.logicsniffer.sampleprocessor.SampleProcessorCallback;

public final class RleDecoder
implements SampleProcessor {
    private static final Logger LOG = Logger.getLogger(RleDecoder.class.getName());
    private final LogicSnifferConfig config;
    private final int[] buffer;
    private final int trigCount;
    private final SampleProcessorCallback callback;
    private final int rleCountValue;
    private final int rleCountMask;

    public RleDecoder(LogicSnifferConfig aConfig, int[] aBuffer, int aTrigCount, SampleProcessorCallback aCallback) {
        if (aBuffer == null) {
            throw new IllegalArgumentException("Buffer cannot be null!");
        }
        this.config = aConfig;
        this.buffer = aBuffer;
        this.trigCount = aTrigCount;
        this.callback = aCallback;
        int width = this.config.getRLEDataWidth();
        switch (width) {
            case 32: {
                this.rleCountValue = Integer.MIN_VALUE;
                this.rleCountMask = this.rleCountValue - 1;
                break;
            }
            case 24: {
                this.rleCountValue = 0x800000;
                this.rleCountMask = this.rleCountValue - 1;
                break;
            }
            case 16: {
                this.rleCountValue = 32768;
                this.rleCountMask = this.rleCountValue - 1;
                break;
            }
            case 8: {
                this.rleCountValue = 128;
                this.rleCountMask = this.rleCountValue - 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal RLE width! Should be 8, 16, 24 or 32!");
            }
        }
    }

    @Override
    public void process() {
        long time = 0L;
        long rleTrigPos = 0L;
        int lastSample = -1;
        int samples = this.buffer.length;
        int rleShiftBits = this.config.getRLEDataWidth();
        boolean ddrMode = this.config.isDoubleDataRateEnabled();
        for (int i = 0; i < samples; ++i) {
            int sampleValue = this.buffer[i];
            int normalizedSampleValue = this.normalizeSampleValue(sampleValue);
            if ((normalizedSampleValue & this.rleCountValue) != 0) {
                long count = normalizedSampleValue & this.rleCountMask;
                if (ddrMode && i < samples - 1) {
                    long ddrCount = count << rleShiftBits | (long)this.normalizeSampleValue(this.buffer[++i]);
                    count = 2L * ddrCount;
                }
                if (lastSample >= 0) {
                    time += count;
                    continue;
                }
                LOG.warning("Ignoring RLE count without preceeding sample value: " + Long.toHexString(count));
                continue;
            }
            if (sampleValue != lastSample) {
                if (i >= this.trigCount && rleTrigPos == 0L) {
                    rleTrigPos = time;
                }
                this.callback.addValue(sampleValue, time);
                lastSample = sampleValue;
            }
            ++time;
        }
        this.callback.addValue(lastSample, time);
        this.callback.ready(time + 1L, rleTrigPos - 1L);
    }

    private int normalizeSampleValue(int aSampleValue) {
        int groupCount = this.config.getGroupCount();
        int compdata = 0;
        int indata = aSampleValue;
        int outcount = 0;
        for (int j = 0; j < groupCount; ++j) {
            if (this.config.isGroupEnabled(j)) {
                compdata |= (indata & 0xFF) << 8 * outcount++;
            }
            indata >>= 8;
        }
        return compdata;
    }
}

