/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.drag;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import javax.swing.JPanel;
import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowTab;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.ui.DockableDescriptor;
import org.noos.xing.mydoggy.plaf.ui.cmp.ExtendedTableLayout;
import org.noos.xing.mydoggy.plaf.ui.drag.MyDoggyTransferable;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class ToolWindowBarDropTarget
extends DropTarget {
    protected MyDoggyToolWindowManager manager;
    protected ToolWindowAnchor anchor;
    protected Container container;
    protected TableLayout layout;
    protected Point lastPosition;

    public ToolWindowBarDropTarget(MyDoggyToolWindowManager manager, ToolWindowAnchor anchor, Container container) throws HeadlessException {
        super(container, new ToolWindowBarDropTargetListener(manager, anchor));
        this.manager = manager;
        this.anchor = anchor;
        this.container = container;
        this.layout = (TableLayout)container.getLayout();
        this.lastPosition = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int showPosition(DropTargetDragEvent dtde, int lastIndex) {
        int direction;
        int[] intervals;
        int position;
        Point newPosition = dtde.getLocation();
        if (this.lastPosition != null && this.lastPosition.equals(newPosition)) {
            return lastIndex;
        }
        int index = -1;
        ExtendedTableLayout tableLayout = (ExtendedTableLayout)this.container.getLayout();
        double sum = 0.0;
        switch (this.anchor) {
            case TOP: 
            case BOTTOM: {
                position = newPosition.x;
                intervals = tableLayout.getColsInPixel();
                if (this.lastPosition == null) {
                    direction = 1;
                    break;
                }
                if (newPosition.x > this.lastPosition.x) {
                    direction = 1;
                    break;
                }
                direction = -1;
                break;
            }
            case LEFT: 
            case RIGHT: {
                position = newPosition.y;
                intervals = tableLayout.getRowsInPixel();
                if (this.lastPosition == null) {
                    direction = 1;
                    break;
                }
                if (newPosition.y > this.lastPosition.y) {
                    direction = 1;
                    break;
                }
                direction = -1;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid anchor.");
            }
        }
        boolean fromUp = false;
        block12: for (int i = 0; i < intervals.length; ++i) {
            double interval = intervals[i];
            if (interval == 0.0 && i != 0) {
                fromUp = true;
            }
            if ((double)position >= sum && (double)position <= sum + interval) {
                if (i % 2 == 0 && i != 0) {
                    i += direction;
                    switch (this.anchor) {
                        case TOP: 
                        case BOTTOM: {
                            if (i < this.layout.getNumColumn()) break;
                            sum += interval;
                            this.hidePosition(false);
                            continue block12;
                        }
                        case LEFT: 
                        case RIGHT: {
                            if (i < this.layout.getNumRow()) break;
                            sum += interval;
                            this.hidePosition(false);
                            continue block12;
                        }
                    }
                }
                this.hidePosition(false);
                switch (this.anchor) {
                    case TOP: 
                    case BOTTOM: {
                        this.container.add((Component)new VerticalSeparatorLabel(), i + ",1,c,c");
                        this.layout.setColumn(i, this.manager.getGlassPanel().getDraggingImage().getWidth(this.container) + 6);
                        break;
                    }
                    case LEFT: 
                    case RIGHT: {
                        this.container.add((Component)new HorizontalSeparatorLabel(), "1," + i + ",c,c");
                        this.layout.setRow(i, this.manager.getGlassPanel().getDraggingImage().getHeight(this.container) + 6);
                        break;
                    }
                }
                index = i / 2;
                if (!fromUp) break;
                --index;
                break;
            }
            sum += interval;
        }
        SwingUtil.repaint(this.container);
        this.lastPosition = newPosition;
        return index;
    }

    protected void hidePosition(boolean repaint) {
        for (Component component : this.container.getComponents()) {
            if (!(component instanceof SeparatorLabel)) continue;
            if (component instanceof HorizontalSeparatorLabel) {
                this.layout.setRow(this.layout.getConstraints((Component)component).row1, 3.0);
            } else {
                this.layout.setColumn(this.layout.getConstraints((Component)component).col1, 3.0);
            }
            this.container.remove(component);
        }
        if (repaint) {
            SwingUtil.repaint(this.container);
        }
    }

    protected static class HorizontalSeparatorLabel
    extends JPanel
    implements SeparatorLabel {
    }

    protected static class VerticalSeparatorLabel
    extends JPanel
    implements SeparatorLabel {
    }

    protected static interface SeparatorLabel {
    }

    protected static class ToolWindowBarDropTargetListener
    extends DropTargetAdapter {
        protected MyDoggyToolWindowManager manager;
        protected ToolWindowAnchor anchor;
        protected int index;

        public ToolWindowBarDropTargetListener(MyDoggyToolWindowManager manager, ToolWindowAnchor anchor) {
            this.manager = manager;
            this.anchor = anchor;
        }

        public void drop(DropTargetDropEvent dtde) {
            Transferable transferable = dtde.getTransferable();
            if (transferable.isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_ID_DF)) {
                this.dropToolWindow(transferable, dtde);
            } else if (transferable.isDataFlavorSupported(MyDoggyTransferable.CONTENT_ID_DF)) {
                this.dropContent(transferable, dtde);
            } else if (transferable.isDataFlavorSupported(MyDoggyTransferable.CUSTOM_DESCRIPTOR_ID)) {
                this.dropBar2Bar(transferable, dtde);
            } else {
                dtde.rejectDrop();
            }
        }

        public void dragEnter(DropTargetDragEvent dtde) {
            if (this.checkEvent(dtde)) {
                this.index = ((ToolWindowBarDropTarget)dtde.getDropTargetContext().getDropTarget()).showPosition(dtde, this.index);
            }
        }

        public void dragOver(DropTargetDragEvent dtde) {
            if (this.checkEvent(dtde)) {
                this.index = ((ToolWindowBarDropTarget)dtde.getDropTargetContext().getDropTarget()).showPosition(dtde, this.index);
            }
        }

        public void dragExit(DropTargetEvent dte) {
            ((ToolWindowBarDropTarget)dte.getDropTargetContext().getDropTarget()).hidePosition(true);
            this.index = -1;
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
            if (this.checkEvent(dtde)) {
                // empty if block
            }
        }

        public boolean checkEvent(DropTargetDragEvent dtde) {
            Transferable transferable = dtde.getTransferable();
            try {
                if (transferable == null) {
                    return false;
                }
                if (transferable.isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_MANAGER) && transferable.getTransferData(MyDoggyTransferable.TOOL_WINDOW_MANAGER).equals(System.identityHashCode(this.manager)) && (transferable.isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_ID_DF) || transferable.isDataFlavorSupported(MyDoggyTransferable.CONTENT_ID_DF) || transferable.isDataFlavorSupported(MyDoggyTransferable.CUSTOM_DESCRIPTOR_ID))) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void dropToolWindow(Transferable transferable, DropTargetDropEvent dtde) {
            ((ToolWindowBarDropTarget)dtde.getDropTargetContext().getDropTarget()).hidePosition(true);
            try {
                String toolId = (String)transferable.getTransferData(MyDoggyTransferable.TOOL_WINDOW_ID_DF);
                ToolWindow toolWindow = this.manager.getToolWindow(toolId);
                if (toolWindow == null) {
                    return;
                }
                dtde.acceptDrop(2);
                if (transferable.isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_TAB_ID_DF)) {
                    ToolWindowTab tab = (ToolWindowTab)this.manager.lookupDockable(transferable.getTransferData(MyDoggyTransferable.TOOL_WINDOW_TAB_ID_DF));
                    tab.getOwner().removeToolWindowTab(tab);
                    toolWindow = (ToolWindow)tab.getDockableDelegator();
                    toolWindow.setAnchor(this.anchor, this.index);
                    toolWindow.setActive(true);
                } else {
                    boolean oldAggregateMode = toolWindow.isAggregateMode();
                    toolWindow.setAggregateMode(true);
                    try {
                        toolWindow.setAnchor(this.anchor, this.index);
                        Object var7_8 = null;
                        toolWindow.setAggregateMode(oldAggregateMode);
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        toolWindow.setAggregateMode(oldAggregateMode);
                        throw throwable;
                    }
                }
                dtde.dropComplete(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                dtde.rejectDrop();
            }
        }

        protected void dropContent(Transferable transferable, DropTargetDropEvent dtde) {
            ((ToolWindowBarDropTarget)dtde.getDropTargetContext().getDropTarget()).hidePosition(true);
            try {
                String contentId = (String)transferable.getTransferData(MyDoggyTransferable.CONTENT_ID_DF);
                Content content = this.manager.getContentManager().getContent(contentId);
                if (content == null) {
                    return;
                }
                dtde.acceptDrop(2);
                if (content.getDockableDelegator() != null && content.getDockableDelegator() instanceof ToolWindow) {
                    ToolWindow toolWindow = (ToolWindow)content.getDockableDelegator();
                    this.manager.getContentManager().removeContent(content);
                    toolWindow.setAnchor(this.anchor, this.index);
                    toolWindow.setActive(true);
                }
                dtde.dropComplete(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                dtde.rejectDrop();
            }
        }

        protected void dropBar2Bar(Transferable transferable, DropTargetDropEvent dtde) {
            ((ToolWindowBarDropTarget)dtde.getDropTargetContext().getDropTarget()).hidePosition(true);
            try {
                String dockableDescriptorId = (String)transferable.getTransferData(MyDoggyTransferable.CUSTOM_DESCRIPTOR_ID);
                DockableDescriptor dockableDescriptor = this.manager.getDockableDescriptor(dockableDescriptorId);
                if (dockableDescriptor == null) {
                    return;
                }
                dtde.acceptDrop(2);
                dockableDescriptor.setAnchor(this.anchor, this.index);
                dtde.dropComplete(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                dtde.rejectDrop();
            }
        }
    }
}

