/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.noos.common.Question;
import org.noos.xing.mydoggy.Dockable;
import org.noos.xing.mydoggy.DockedTypeDescriptor;
import org.noos.xing.mydoggy.FloatingLiveTypeDescriptor;
import org.noos.xing.mydoggy.FloatingTypeDescriptor;
import org.noos.xing.mydoggy.RepresentativeAnchorDescriptor;
import org.noos.xing.mydoggy.SlidingTypeDescriptor;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAction;
import org.noos.xing.mydoggy.ToolWindowActionHandler;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowTab;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.ToolWindowTypeDescriptor;
import org.noos.xing.mydoggy.event.ToolWindowManagerEvent;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindow;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowBar;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.PropertyChangeEventSource;
import org.noos.xing.mydoggy.plaf.actions.AggregateMenuToolWindowAction;
import org.noos.xing.mydoggy.plaf.actions.AggregateToolWindowAction;
import org.noos.xing.mydoggy.plaf.actions.DockToolWindowAction;
import org.noos.xing.mydoggy.plaf.actions.FloatingLiveToolWindowAction;
import org.noos.xing.mydoggy.plaf.actions.FloatingToolWindowAction;
import org.noos.xing.mydoggy.plaf.actions.HideToolWindowAction;
import org.noos.xing.mydoggy.plaf.actions.IndexMenuToolWindowAction;
import org.noos.xing.mydoggy.plaf.actions.MaximizeToolWindowAction;
import org.noos.xing.mydoggy.plaf.actions.MoveToToolWindowAction;
import org.noos.xing.mydoggy.plaf.actions.PinToolWindowAction;
import org.noos.xing.mydoggy.plaf.actions.PlafToolWindowAction;
import org.noos.xing.mydoggy.plaf.actions.ToolsMenuToolWindowAction;
import org.noos.xing.mydoggy.plaf.cleaner.Cleaner;
import org.noos.xing.mydoggy.plaf.cleaner.CleanerAggregator;
import org.noos.xing.mydoggy.plaf.cleaner.DefaultCleanerAggregator;
import org.noos.xing.mydoggy.plaf.common.context.DefaultMutableContext;
import org.noos.xing.mydoggy.plaf.descriptors.DefaultExternTypeDescriptor;
import org.noos.xing.mydoggy.plaf.descriptors.InternalTypeDescriptor;
import org.noos.xing.mydoggy.plaf.descriptors.ToolWindowRepresentativeAnchorDescriptor;
import org.noos.xing.mydoggy.plaf.ui.DockableDescriptor;
import org.noos.xing.mydoggy.plaf.ui.DockedContainer;
import org.noos.xing.mydoggy.plaf.ui.FloatingContainer;
import org.noos.xing.mydoggy.plaf.ui.FloatingLiveContainer;
import org.noos.xing.mydoggy.plaf.ui.PopupUpdater;
import org.noos.xing.mydoggy.plaf.ui.SlidingContainer;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowContainer;
import org.noos.xing.mydoggy.plaf.ui.cmp.AggregateIcon;
import org.noos.xing.mydoggy.plaf.ui.cmp.FloatingLiveWindow;
import org.noos.xing.mydoggy.plaf.ui.cmp.FloatingWindow;
import org.noos.xing.mydoggy.plaf.ui.cmp.TextIcon;
import org.noos.xing.mydoggy.plaf.ui.cmp.ToolWindowPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.ToolWindowRepresentativeAnchor;
import org.noos.xing.mydoggy.plaf.ui.cmp.ToolWindowTitleBar;
import org.noos.xing.mydoggy.plaf.ui.cmp.ToolWindowTitleButton;
import org.noos.xing.mydoggy.plaf.ui.cmp.ToolWindowTitleButtonPanel;
import org.noos.xing.mydoggy.plaf.ui.util.GraphicsUtil;
import org.noos.xing.mydoggy.plaf.ui.util.ParentOfQuestion;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;
import org.noos.xing.mydoggy.plaf.ui.util.ToolWindowManagerListenerAdapter;

public class ToolWindowDescriptor
implements PropertyChangeListener,
DockableDescriptor {
    protected MyDoggyToolWindowManager manager;
    protected MyDoggyToolWindow toolWindow;
    protected CleanerAggregator cleaner;
    protected boolean anchorPositionLocked = false;
    protected boolean floatingWindow = false;
    protected ToolWindowPanel toolWindowPanel;
    protected PropertyChangeListener focusListener;
    protected ToolWindowContainer dockedContainer;
    protected ToolWindowContainer floatingContainer;
    protected ToolWindowContainer slidingContainer;
    protected ToolWindowContainer floatingLiveContainer;
    protected Component focusRequester;
    protected Component component;
    protected JLabel representativeAnchor;
    protected int divederLocation = -1;
    protected int tempDivederLocation;
    protected FloatingTypeDescriptor floatingTypeDescriptor;
    protected DockedTypeDescriptor dockedTypeDescriptor;
    protected SlidingTypeDescriptor slidingTypeDescriptor;
    protected FloatingLiveTypeDescriptor floatingLiveTypeDescriptor;
    protected RepresentativeAnchorDescriptor representativeAnchorDescriptor;
    protected ToolWindowTypeDescriptor externTypeDescriptor;
    boolean dockLengthValueAdjusting = false;
    boolean internalFocusValueAdjusting;
    public boolean externalFocusValueAdjusting = false;
    public static boolean fullExternalFocusValueAdjusting = false;
    protected ToolWindowType oldType;
    protected JPopupMenu popupMenu;
    protected JMenu old;
    protected ArrayList<PopupUpdater> popupUpdaterList;

    public ToolWindowDescriptor(MyDoggyToolWindowManager manager, MyDoggyToolWindow toolWindow) {
        this.manager = manager;
        this.toolWindow = toolWindow;
        this.cleaner = new ToolWindowDescriptorCleaner();
        this.initListeners();
        this.initTypeDescriptors();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("type".equals(propertyName)) {
            if (evt.getOldValue() == ToolWindowType.FLOATING_FREE || evt.getNewValue() == ToolWindowType.FLOATING_FREE) {
                this.setFloatingWindow(true);
            } else if (evt.getOldValue() == ToolWindowType.FLOATING || evt.getNewValue() == ToolWindowType.FLOATING) {
                this.setFloatingWindow(false);
            }
            if (evt.getSource() != this.toolWindow || evt.getNewValue() != ToolWindowType.FLOATING && evt.getNewValue() != ToolWindowType.FLOATING_FREE) {
                return;
            }
            this.oldType = (ToolWindowType)((Object)evt.getOldValue());
        } else if ("index".equals(propertyName)) {
            this.updateRepresentativeAnchor();
        } else if ("numberingEnabled".equals(propertyName)) {
            this.updateRepresentativeAnchor();
        } else if ("icon".equals(propertyName)) {
            this.updateRepresentativeAnchor();
        } else if (evt.getSource() instanceof RepresentativeAnchorDescriptor && "title".equals(propertyName)) {
            this.updateRepresentativeAnchor();
        } else if (evt.getSource() instanceof RepresentativeAnchorDescriptor && "icon".equals(propertyName)) {
            this.updateRepresentativeAnchor();
        } else if ("dockLength".equals(propertyName)) {
            if (!this.dockLengthValueAdjusting) {
                this.divederLocation = (Integer)evt.getNewValue();
                this.getToolBar(this.toolWindow.getAnchor()).propertyChange(new PropertyChangeEvent(this.toolWindow, propertyName, evt.getOldValue(), evt.getNewValue()));
            }
        } else if ("hideRepresentativeButtonOnVisible".equals(propertyName)) {
            if (this.toolWindow.isVisible()) {
                this.toolWindow.getRepresentativeAnchorDescriptor().setVisible((Boolean)evt.getNewValue() == false);
            }
        } else if ("UI".equals(propertyName)) {
            this.initPopupMenu();
            SwingUtilities.updateComponentTreeUI(this.popupMenu);
            DockedTypeDescriptor descriptor = (DockedTypeDescriptor)this.toolWindow.getTypeDescriptor(ToolWindowType.DOCKED);
            SwingUtilities.updateComponentTreeUI(descriptor.getToolsMenu());
        }
    }

    public String toString() {
        return "ToolWindowDescriptor{toolWindow=" + this.toolWindow + '}';
    }

    public ToolWindowAnchor getAnchor() {
        return this.toolWindow.getAnchor();
    }

    public void setAnchorPositionLocked(boolean anchorPositionLocked) {
        this.anchorPositionLocked = anchorPositionLocked;
    }

    public boolean isAnchorPositionLocked() {
        return this.anchorPositionLocked;
    }

    public void setAvailable(boolean available) {
        this.toolWindow.setAvailable(available);
    }

    public boolean isAvailable() {
        return this.toolWindow.isAvailable();
    }

    public boolean isAvailableCountable() {
        return true;
    }

    public DockableDescriptor.DockableType getDockableType() {
        return DockableDescriptor.DockableType.TOOL_WINDOW;
    }

    public Dockable getDockable() {
        return this.toolWindow;
    }

    public JLabel getRepresentativeAnchor(Component parent) {
        if (this.representativeAnchor == null) {
            ToolWindowAnchor anchor = this.toolWindow.getAnchor();
            String labelText = SwingUtil.getUserString(this.toolWindow.getRepresentativeAnchorDescriptor().getTitle());
            String toolRepresentativeAnchorText = this.toolWindow.getIndex() > 0 && this.getManager().getToolWindowManagerDescriptor().isNumberingEnabled() ? this.toolWindow.getIndex() + " : " + labelText : labelText;
            Icon toolIcon = this.toolWindow.isAvailable() || this.toolWindow.getIcon() == null ? this.toolWindow.getIcon() : new ImageIcon(GrayFilter.createDisabledImage(GraphicsUtil.getImage(this.representativeAnchor, this.toolWindow.getIcon())));
            switch (anchor) {
                case BOTTOM: 
                case TOP: {
                    this.representativeAnchor = new ToolWindowRepresentativeAnchor(this, toolRepresentativeAnchorText, toolIcon, 0);
                    break;
                }
                case LEFT: {
                    if (SwingUtil.getBoolean("RepresentativeAnchorButton.icon.rotateOnAanchor", false) && toolIcon != null) {
                        toolIcon = GraphicsUtil.rotate(toolIcon, -1.5707963267948966);
                    }
                    TextIcon textIcon = new TextIcon(parent, toolRepresentativeAnchorText, 2);
                    textIcon.setForeground(this.toolWindow.isAvailable() ? UIManager.getColor("ToolWindowRepresentativeAnchorUI.foreground") : UIManager.getColor("ToolWindowRepresentativeAnchorUI.foreground.unavailable"));
                    AggregateIcon compositeIcon = new AggregateIcon(textIcon, toolIcon, 1);
                    this.representativeAnchor = new ToolWindowRepresentativeAnchor(this, (Icon)compositeIcon, 0);
                    break;
                }
                case RIGHT: {
                    if (SwingUtil.getBoolean("RepresentativeAnchorButton.icon.rotateOnAanchor", false) && toolIcon != null) {
                        toolIcon = GraphicsUtil.rotate(toolIcon, 1.5707963267948966);
                    }
                    TextIcon textIcon = new TextIcon(parent, toolRepresentativeAnchorText, 3);
                    textIcon.setForeground(this.toolWindow.isAvailable() ? UIManager.getColor("ToolWindowRepresentativeAnchorUI.foreground") : UIManager.getColor("ToolWindowRepresentativeAnchorUI.foreground.unavailable"));
                    AggregateIcon compositeIcon = new AggregateIcon(toolIcon, textIcon, 1);
                    this.representativeAnchor = new ToolWindowRepresentativeAnchor(this, (Icon)compositeIcon, 0);
                }
            }
            this.representativeAnchor.setName("toolWindow.rb." + this.toolWindow.getId());
            this.representativeAnchor.setOpaque(this.toolWindow.isActive());
            this.representativeAnchor.setFocusable(false);
            this.representativeAnchor.putClientProperty(ToolWindowDescriptor.class, this);
        }
        return this.representativeAnchor;
    }

    public JLabel getRepresentativeAnchor() {
        return this.representativeAnchor;
    }

    public void resetRepresentativeAnchor() {
        if (this.representativeAnchor != null) {
            this.representativeAnchor.putClientProperty(ToolWindowDescriptor.class, null);
            this.representativeAnchor.setUI(null);
            this.representativeAnchor = null;
        }
    }

    public int getAnchorIndex() {
        if (this.representativeAnchor == null) {
            return -1;
        }
        return this.getToolBar().getRepresentativeAnchorIndex(this.representativeAnchor);
    }

    public void updateRepresentativeAnchor() {
        if (this.representativeAnchor != null) {
            ToolWindowAnchor anchor = this.toolWindow.getAnchor();
            String labelText = SwingUtil.getUserString(this.toolWindow.getRepresentativeAnchorDescriptor().getTitle());
            String toolRepresentativeAnchorText = this.toolWindow.getIndex() > 0 && this.getManager().getToolWindowManagerDescriptor().isNumberingEnabled() ? this.toolWindow.getIndex() + " : " + labelText : labelText;
            Icon toolIcon = this.toolWindow.isAvailable() || this.toolWindow.getIcon() == null ? this.toolWindow.getIcon() : new ImageIcon(GrayFilter.createDisabledImage(GraphicsUtil.getImage(this.representativeAnchor, this.toolWindow.getIcon())));
            switch (anchor) {
                case BOTTOM: 
                case TOP: {
                    this.representativeAnchor.setIcon(toolIcon);
                    this.representativeAnchor.setText(toolRepresentativeAnchorText);
                    break;
                }
                case LEFT: {
                    if (SwingUtil.getBoolean("RepresentativeAnchorButton.icon.rotateOnAanchor", false) && toolIcon != null) {
                        toolIcon = GraphicsUtil.rotate(toolIcon, -1.5707963267948966);
                    }
                    TextIcon textIcon = new TextIcon(((TextIcon)((AggregateIcon)this.representativeAnchor.getIcon()).getLeftIcon()).getComponent(), toolRepresentativeAnchorText, 2);
                    textIcon.setForeground(this.toolWindow.isAvailable() ? UIManager.getColor("ToolWindowRepresentativeAnchorUI.foreground") : UIManager.getColor("ToolWindowRepresentativeAnchorUI.foreground.unavailable"));
                    AggregateIcon compositeIcon = new AggregateIcon(textIcon, toolIcon, 1);
                    this.representativeAnchor.setText(null);
                    this.representativeAnchor.setIcon(compositeIcon);
                    break;
                }
                case RIGHT: {
                    if (SwingUtil.getBoolean("RepresentativeAnchorButton.icon.rotateOnAanchor", false) && toolIcon != null) {
                        toolIcon = GraphicsUtil.rotate(toolIcon, 1.5707963267948966);
                    }
                    TextIcon textIcon = new TextIcon(((TextIcon)((AggregateIcon)this.representativeAnchor.getIcon()).getRightIcon()).getComponent(), toolRepresentativeAnchorText, 3);
                    textIcon.setForeground(this.toolWindow.isAvailable() ? UIManager.getColor("ToolWindowRepresentativeAnchorUI.foreground") : UIManager.getColor("ToolWindowRepresentativeAnchorUI.foreground.unavailable"));
                    AggregateIcon compositeIcon = new AggregateIcon(toolIcon, textIcon, 1);
                    this.representativeAnchor.setText(null);
                    this.representativeAnchor.setIcon(compositeIcon);
                }
            }
        }
    }

    public MyDoggyToolWindowManager getManager() {
        return this.manager;
    }

    public MyDoggyToolWindowBar getToolBar(ToolWindowAnchor anchor) {
        return this.manager.getBar(anchor);
    }

    public MyDoggyToolWindowBar getToolBar() {
        return this.manager.getBar(this.toolWindow.getAnchor());
    }

    public boolean isDragImageAvailable() {
        return true;
    }

    public Component getComponentForDragImage() {
        return this.getToolWindowPanel();
    }

    public void setAnchor(ToolWindowAnchor anchor, int index) {
        this.toolWindow.setAnchor(anchor, index);
    }

    public CleanerAggregator getCleaner() {
        return this.cleaner;
    }

    public void cleanup() {
        this.getCleaner().cleanup();
    }

    public MyDoggyToolWindow getToolWindow() {
        return this.toolWindow;
    }

    public ToolWindowPanel getToolWindowPanel() {
        return this.toolWindowPanel;
    }

    public Component getComponent() {
        if (this.component == null && this.toolWindow.getToolWindowTabs().length > 0) {
            this.component = this.toolWindow.getToolWindowTabs()[0].getComponent();
        }
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
        this.toolWindowPanel.setComponent(this.component);
    }

    public int getDividerLocation() {
        if (this.divederLocation == -1) {
            this.divederLocation = ((DockedTypeDescriptor)this.getTypeDescriptor(ToolWindowType.DOCKED)).getDockLength();
        }
        return this.divederLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDividerLocation(int divederLocation) {
        if (divederLocation <= 0) {
            return;
        }
        this.divederLocation = divederLocation;
        DockedTypeDescriptor dockedTypeDescriptor = (DockedTypeDescriptor)this.toolWindow.getTypeDescriptor(ToolWindowType.DOCKED);
        this.dockLengthValueAdjusting = true;
        try {
            dockedTypeDescriptor.setDockLength(divederLocation);
        }
        finally {
            this.dockLengthValueAdjusting = false;
        }
    }

    public int getTempDivederLocation() {
        return this.tempDivederLocation;
    }

    public void setTempDivederLocation(int tempDivederLocation) {
        this.tempDivederLocation = tempDivederLocation;
    }

    public boolean isFloatingWindow() {
        return this.floatingWindow;
    }

    public void setFloatingWindow(boolean floatingWindow) {
        this.floatingWindow = floatingWindow;
    }

    public boolean isIdVisibleOnTitleBar() {
        switch (this.toolWindow.getType()) {
            case DOCKED: {
                return this.toolWindow.getTypeDescriptor(ToolWindowType.DOCKED).isIdVisibleOnTitleBar();
            }
            case SLIDING: {
                return this.toolWindow.getTypeDescriptor(ToolWindowType.SLIDING).isIdVisibleOnTitleBar();
            }
            case FLOATING: 
            case FLOATING_FREE: {
                return this.toolWindow.getTypeDescriptor(ToolWindowType.FLOATING).isIdVisibleOnTitleBar();
            }
            case FLOATING_LIVE: {
                return this.toolWindow.getTypeDescriptor(ToolWindowType.FLOATING_LIVE).isIdVisibleOnTitleBar();
            }
            case EXTERN: {
                return true;
            }
        }
        throw new IllegalStateException("ToolWindowDescriptor.isIdVisibleOnTitleBar");
    }

    public void updateUI() {
        this.getToolWindowContainer().updateUI();
        SwingUtilities.updateComponentTreeUI(this.getComponent());
        for (ToolWindowTab tab : this.toolWindow.getToolWindowTabs()) {
            SwingUtilities.updateComponentTreeUI(tab.getComponent());
        }
        if (this.getRepresentativeAnchor() != null) {
            this.getRepresentativeAnchor().updateUI();
        }
    }

    public Rectangle getManagerBounds() {
        return SwingUtilities.convertRectangle(this.manager, this.manager.getBounds(), this.manager.getRootPaneContainer().getContentPane());
    }

    public Window getWindowAncestor() {
        return this.manager.getWindowAncestor() instanceof Window ? (Window)this.manager.getWindowAncestor() : null;
    }

    public ToolWindowContainer getToolWindowContainer() {
        if (this.dockedContainer == null) {
            this.initContainers();
        }
        return this.dockedContainer;
    }

    public ToolWindowContainer getToolWindowContainer(ToolWindowType type) {
        if (this.dockedContainer == null) {
            this.initContainers();
        }
        switch (type) {
            case FLOATING: 
            case FLOATING_FREE: {
                return this.floatingContainer;
            }
            case FLOATING_LIVE: {
                return this.floatingLiveContainer;
            }
            case DOCKED: {
                return this.dockedContainer;
            }
            case SLIDING: {
                return this.slidingContainer;
            }
        }
        throw new IllegalArgumentException("Type not recognized.");
    }

    public ToolWindowTypeDescriptor getTypeDescriptor(ToolWindowType type) {
        switch (type) {
            case FLOATING: 
            case FLOATING_FREE: {
                return this.floatingTypeDescriptor;
            }
            case FLOATING_LIVE: {
                return this.floatingLiveTypeDescriptor;
            }
            case DOCKED: {
                return this.dockedTypeDescriptor;
            }
            case SLIDING: {
                return this.slidingTypeDescriptor;
            }
            case EXTERN: {
                return this.externTypeDescriptor;
            }
        }
        throw new IllegalStateException("Doen't exist a TypeDescriptor for. [type : " + (Object)((Object)type) + "]");
    }

    public DockedTypeDescriptor getDockedTypeDescriptor() {
        return this.dockedTypeDescriptor;
    }

    public ToolWindowTypeDescriptor getTypeDescriptor() {
        return this.toolWindow.getTypeDescriptor(this.toolWindow.getType());
    }

    public RepresentativeAnchorDescriptor getRepresentativeAnchorDescriptor() {
        return this.representativeAnchorDescriptor;
    }

    public void hideToolWindow() {
        ToolWindowActionHandler toolWindowActionHandler = this.toolWindow.getTypeDescriptor(DockedTypeDescriptor.class).getToolWindowActionHandler();
        if (toolWindowActionHandler != null) {
            toolWindowActionHandler.onHideButtonClick(this.toolWindow);
        } else {
            this.toolWindow.setVisible(false);
        }
    }

    public void assignFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ToolWindowDescriptor.this.focusRequester = ToolWindowDescriptor.this.toolWindowPanel.getFocusable();
                if (ToolWindowDescriptor.this.focusRequester == null) {
                    return;
                }
                ToolWindowDescriptor.this.focusRequester.setFocusable(true);
                ToolWindowDescriptor.this.focusRequester.requestFocusInWindow();
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Component toolWindowPanelFocusable = ToolWindowDescriptor.this.toolWindowPanel.getFocusable();
                if (toolWindowPanelFocusable == null) {
                    return;
                }
                if (toolWindowPanelFocusable.isFocusOwner()) {
                    ToolWindowDescriptor.this.focusRequester = SwingUtil.findFocusable(ToolWindowDescriptor.this.getComponent());
                    if (ToolWindowDescriptor.this.focusRequester != null) {
                        ToolWindowDescriptor.this.focusRequester.requestFocusInWindow();
                        toolWindowPanelFocusable.setFocusable(false);
                    } else {
                        toolWindowPanelFocusable.requestFocusInWindow();
                    }
                } else {
                    ToolWindowDescriptor.this.assignFocus();
                }
            }
        });
    }

    public void showPopupMenu(Component source, int x, int y) {
        this.initPopupMenu();
        ToolWindowTitleBar toolWindowTitleBar = this.toolWindowPanel.getToolWindowTitleBar();
        if (source == toolWindowTitleBar || SwingUtil.hasParent(source, toolWindowTitleBar) || source instanceof ToolWindowRepresentativeAnchor) {
            this.popupMenu.removeAll();
            ToolWindowTypeDescriptor typeDescriptor = this.toolWindow.getTypeDescriptor(this.toolWindow.getType());
            this.addPopupAction(this.popupMenu, typeDescriptor.getToolWindowAction("PIN_ACTION_ID"));
            this.addPopupAction(this.popupMenu, typeDescriptor.getToolWindowAction("DOCK_ACTION_ID"));
            this.addPopupAction(this.popupMenu, typeDescriptor.getToolWindowAction("FLOATING_ACTION_ID"));
            this.addPopupAction(this.popupMenu, typeDescriptor.getToolWindowAction("FLOATING_LIVE_ACTION_ID"));
            this.addPopupAction(this.popupMenu, typeDescriptor.getToolWindowAction("MOVE_TO_ACTION_ID"));
            this.addPopupAction(this.popupMenu, typeDescriptor.getToolWindowAction("MAXIMIZE_ACTION_ID"));
            this.addPopupAction(this.popupMenu, typeDescriptor.getToolWindowAction("TOOLS_MENU_ACTION_ID"));
            this.addPopupAction(this.popupMenu, typeDescriptor.getToolWindowAction("INDEX_MENU_ACTION_ID"));
            for (ToolWindowAction toolWindowAction : typeDescriptor.getToolWindowActions()) {
                if (toolWindowAction instanceof PlafToolWindowAction) continue;
                this.addPopupAction(this.popupMenu, toolWindowAction);
            }
            this.popupMenu.addSeparator();
            this.addPopupAction(this.popupMenu, typeDescriptor.getToolWindowAction("HIDE_ACTION_ID"));
            this.addPopupAction(this.popupMenu, typeDescriptor.getToolWindowAction("AGGREGATE_ACTION_ID"));
            this.addPopupAction(this.popupMenu, typeDescriptor.getToolWindowAction("AGGREGATE_MENU_ACTION_ID"));
            if (this.popupUpdaterList != null) {
                for (PopupUpdater popupUpdater : this.popupUpdaterList) {
                    popupUpdater.update(source, this.popupMenu);
                }
            }
            this.popupMenu.show(source, x, y);
        }
    }

    public void addPopupUpdater(PopupUpdater popupUpdater) {
        if (this.popupUpdaterList == null) {
            this.popupUpdaterList = new ArrayList();
        }
        this.popupUpdaterList.add(popupUpdater);
    }

    public void removePopupUpdater(PopupUpdater popupUpdater) {
        if (this.popupUpdaterList == null) {
            return;
        }
        this.popupUpdaterList.remove(popupUpdater);
    }

    public void addTypeDescriptorChangePropertyListener(PropertyChangeListener listener) {
        this.floatingTypeDescriptor.addPropertyChangeListener(listener);
        this.floatingLiveTypeDescriptor.addPropertyChangeListener(listener);
        this.dockedTypeDescriptor.addPropertyChangeListener(listener);
        this.slidingTypeDescriptor.addPropertyChangeListener(listener);
    }

    public void removeTypeDescriptorChangePropertyListener(PropertyChangeListener listener) {
        this.floatingTypeDescriptor.removePropertyChangeListener(listener);
        this.floatingLiveTypeDescriptor.removePropertyChangeListener(listener);
        this.dockedTypeDescriptor.removePropertyChangeListener(listener);
        this.slidingTypeDescriptor.removePropertyChangeListener(listener);
    }

    public void removeFloatingLiveWindow() {
        this.manager.removeFloatingLiveWindow(this.toolWindow);
    }

    public FloatingLiveWindow getFloatingLiveWindow() {
        return this.manager.getFloatingLiveWindow(this.toolWindow);
    }

    public void removeFloatingWindow() {
        this.manager.removeFloatingWindow(this.toolWindow);
    }

    public FloatingWindow getFloatingWindow() {
        return this.manager.getFloatingWindow(this.toolWindow);
    }

    public Rectangle getScreenWindowBounds() {
        return SwingUtil.getScreenWindowBounds(this.getFloatingWindow().getWindow());
    }

    public void addCommonToolWindowAction(ToolWindowAction toolWindowAction) {
        this.getTypeDescriptor(ToolWindowType.DOCKED).addToolWindowAction(toolWindowAction);
        this.getTypeDescriptor(ToolWindowType.SLIDING).addToolWindowAction(toolWindowAction);
        this.getTypeDescriptor(ToolWindowType.FLOATING).addToolWindowAction(toolWindowAction);
        this.getTypeDescriptor(ToolWindowType.FLOATING_LIVE).addToolWindowAction(toolWindowAction);
    }

    public void removeCommonToolWindowAction(String id) {
        this.getTypeDescriptor(ToolWindowType.DOCKED).removeToolWindowAction(id);
        this.getTypeDescriptor(ToolWindowType.SLIDING).removeToolWindowAction(id);
        this.getTypeDescriptor(ToolWindowType.FLOATING).removeToolWindowAction(id);
        this.getTypeDescriptor(ToolWindowType.FLOATING_LIVE).removeToolWindowAction(id);
    }

    public boolean containsToolWindowAction(ToolWindowTypeDescriptor except, String id) {
        if (except != this.dockedTypeDescriptor && this.dockedTypeDescriptor.getToolWindowAction(id) != null) {
            return true;
        }
        if (except != this.slidingTypeDescriptor && this.slidingTypeDescriptor.getToolWindowAction(id) != null) {
            return true;
        }
        if (except != this.floatingTypeDescriptor && this.floatingTypeDescriptor.getToolWindowAction(id) != null) {
            return true;
        }
        return except != this.floatingLiveTypeDescriptor && this.floatingLiveTypeDescriptor.getToolWindowAction(id) != null;
    }

    public boolean containsToolWindowAction(ToolWindowTypeDescriptor except, ToolWindowAction action) {
        if (except != this.dockedTypeDescriptor && this.dockedTypeDescriptor.getToolWindowAction(action.getId()) == action) {
            return true;
        }
        if (except != this.slidingTypeDescriptor && this.slidingTypeDescriptor.getToolWindowAction(action.getId()) == action) {
            return true;
        }
        if (except != this.floatingTypeDescriptor && this.floatingTypeDescriptor.getToolWindowAction(action.getId()) == action) {
            return true;
        }
        return except != this.floatingLiveTypeDescriptor && this.floatingLiveTypeDescriptor.getToolWindowAction(action.getId()) == action;
    }

    protected void initContainers() {
        if (this.toolWindowPanel != null) {
            return;
        }
        this.toolWindowPanel = new ToolWindowPanel(this);
        this.initToolWindowContainers();
        MyDoggyToolWindow toolWindowSource = this.getToolWindow();
        toolWindowSource.addPlafPropertyChangeListener("active", new ActivePropertyChangeListener());
        this.focusListener = new FocusOwnerPropertyChangeListener(this.getManager().getResourceManager().createInstance(ParentOfQuestion.class, new DefaultMutableContext(ToolWindow.class, this.toolWindow, Component.class, this.toolWindowPanel)));
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this.focusListener);
        this.manager.addInternalPropertyChangeListener("managerWindowAncestor", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                if (evt.getNewValue() != null) {
                    keyboardFocusManager.removePropertyChangeListener("focusOwner", ToolWindowDescriptor.this.focusListener);
                    keyboardFocusManager.addPropertyChangeListener("focusOwner", ToolWindowDescriptor.this.focusListener);
                } else {
                    keyboardFocusManager.removePropertyChangeListener("focusOwner", ToolWindowDescriptor.this.focusListener);
                    if (ToolWindowDescriptor.this.toolWindow != null) {
                        ToolWindowDescriptor.this.toolWindow.setFlashing(false);
                    }
                }
            }
        });
        this.focusRequester = SwingUtil.findFocusable(this.getComponent());
        if (this.focusRequester == null) {
            ToolWindowTitleButtonPanel toolWindowTitleButtonPanel = this.toolWindowPanel.getToolWindowTitleBar().getToolWindowTitleButtonPanel();
            toolWindowTitleButtonPanel.getFocusable().setFocusable(true);
            this.focusRequester = toolWindowTitleButtonPanel.getFocusable();
        }
    }

    protected void initToolWindowContainers() {
        this.dockedContainer = new DockedContainer(this);
        this.slidingContainer = new SlidingContainer(this);
        this.floatingContainer = new FloatingContainer(this);
        this.floatingLiveContainer = new FloatingLiveContainer(this);
    }

    protected void initListeners() {
        this.toolWindow.addPlafPropertyChangeListener(this);
        this.manager.addToolWindowManagerListener(new ToolWindowManagerListenerAdapter(){

            public void toolWindowRegistered(ToolWindowManagerEvent event) {
                ToolWindowDescriptor.this.initToolWindowActions();
                ToolWindowDescriptor.this.initContainers();
                ToolWindowDescriptor.this.manager.removeToolWindowManagerListener(this);
            }
        });
        ((PropertyChangeEventSource)((Object)this.manager.getToolWindowManagerDescriptor())).addPlafPropertyChangeListener(this);
    }

    protected void initToolWindowActions() {
        this.toolWindow.addToolWindowAction(new HideToolWindowAction());
        this.toolWindow.addToolWindowAction(new DockToolWindowAction());
        this.toolWindow.addToolWindowAction(new MaximizeToolWindowAction());
        this.toolWindow.addToolWindowAction(new FloatingToolWindowAction());
        this.toolWindow.addToolWindowAction(new PinToolWindowAction());
        this.toolWindow.addToolWindowAction(new FloatingLiveToolWindowAction());
        this.toolWindow.addToolWindowAction(new MoveToToolWindowAction());
        this.toolWindow.addToolWindowAction(new AggregateToolWindowAction());
        this.toolWindow.addToolWindowAction(new AggregateMenuToolWindowAction());
        this.toolWindow.addToolWindowAction(new ToolsMenuToolWindowAction());
        this.toolWindow.addToolWindowAction(new IndexMenuToolWindowAction());
    }

    protected void initTypeDescriptors() {
        this.floatingTypeDescriptor = (FloatingTypeDescriptor)((InternalTypeDescriptor)((Object)this.manager.getTypeDescriptorTemplate(ToolWindowType.FLOATING))).cloneMe(this);
        this.floatingTypeDescriptor.addPropertyChangeListener(this);
        this.floatingLiveTypeDescriptor = (FloatingLiveTypeDescriptor)((InternalTypeDescriptor)((Object)this.manager.getTypeDescriptorTemplate(ToolWindowType.FLOATING_LIVE))).cloneMe(this);
        this.floatingLiveTypeDescriptor.addPropertyChangeListener(this);
        this.slidingTypeDescriptor = (SlidingTypeDescriptor)((InternalTypeDescriptor)((Object)this.manager.getTypeDescriptorTemplate(ToolWindowType.SLIDING))).cloneMe(this);
        this.slidingTypeDescriptor.addPropertyChangeListener(this);
        this.dockedTypeDescriptor = (DockedTypeDescriptor)((InternalTypeDescriptor)((Object)this.manager.getTypeDescriptorTemplate(ToolWindowType.DOCKED))).cloneMe(this);
        this.dockedTypeDescriptor.addPropertyChangeListener(this);
        this.representativeAnchorDescriptor = new ToolWindowRepresentativeAnchorDescriptor(this);
        this.representativeAnchorDescriptor.addPropertyChangeListener(this);
        this.externTypeDescriptor = new DefaultExternTypeDescriptor();
    }

    protected void initPopupMenu() {
        if (this.popupMenu != null) {
            return;
        }
        this.popupMenu = new JPopupMenu("ToolWindowBarPopupMenu");
        this.popupMenu.setLightWeightPopupEnabled(false);
    }

    protected void addPopupAction(JPopupMenu popupMenu, ToolWindowAction toolWindowAction) {
        JMenuItem menuItem;
        if (toolWindowAction.isVisibleOnMenuBar() && (menuItem = toolWindowAction.getMenuItem()) != null) {
            popupMenu.add(menuItem);
        }
    }

    public void disableExternalFocusValueAdjustingLater() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ToolWindowDescriptor.this.externalFocusValueAdjusting = false;
            }
        });
    }

    public void disableFullExternalFocusValueAdjustingLater() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                fullExternalFocusValueAdjusting = false;
            }
        });
    }

    public class ActivePropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            boolean active = (Boolean)evt.getNewValue();
            ToolWindowTitleBar toolWindowTitleBar = ToolWindowDescriptor.this.toolWindowPanel.getToolWindowTitleBar();
            toolWindowTitleBar.setEnabled(active);
            boolean found = false;
            for (ToolWindowTab tab : ToolWindowDescriptor.this.toolWindow.getToolWindowTabs()) {
                if (!tab.isSelected()) continue;
                found = true;
                break;
            }
            if (!found && ToolWindowDescriptor.this.toolWindow.getToolWindowTabs().length > 0) {
                ToolWindowDescriptor.this.toolWindow.getToolWindowTabs()[0].setSelected(true);
            }
            if (active && !ToolWindowDescriptor.this.internalFocusValueAdjusting) {
                if (ToolWindowDescriptor.this.focusRequester != null) {
                    if (ToolWindowDescriptor.this.focusRequester == toolWindowTitleBar.getToolWindowTitleButtonPanel().getFocusable()) {
                        ToolWindowDescriptor.this.assignFocus();
                    } else {
                        SwingUtil.requestFocus(ToolWindowDescriptor.this.focusRequester);
                    }
                } else {
                    ToolWindowDescriptor.this.assignFocus();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FocusOwnerPropertyChangeListener
    implements PropertyChangeListener,
    Cleaner {
        protected Question<Component, Boolean> parentOf;

        public FocusOwnerPropertyChangeListener(Question<Component, Boolean> parentOf) {
            this.parentOf = parentOf;
            ToolWindowDescriptor.this.getCleaner().addBefore(ToolWindowDescriptor.this.dockedContainer, this);
        }

        @Override
        public void cleanup() {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (ToolWindowDescriptor.this.toolWindow == null || !ToolWindowDescriptor.this.toolWindow.isVisible() || ToolWindowDescriptor.this.internalFocusValueAdjusting || ToolWindowDescriptor.this.externalFocusValueAdjusting || fullExternalFocusValueAdjusting) {
                return;
            }
            Component component = (Component)evt.getNewValue();
            if (component == null) {
                return;
            }
            if (component instanceof JRootPane) {
                return;
            }
            ToolWindowDescriptor.this.internalFocusValueAdjusting = true;
            if (this.parentOf.getAnswer(component).booleanValue()) {
                ToolWindowDescriptor.this.toolWindow.setActive(true);
                if (ToolWindowDescriptor.this.focusRequester == null) {
                    ToolWindowDescriptor.this.focusRequester = component;
                } else if (!(ToolWindowDescriptor.this.focusRequester instanceof ToolWindowTitleButton)) {
                    ToolWindowDescriptor.this.focusRequester = component;
                } else if (ToolWindowDescriptor.this.focusRequester == ToolWindowDescriptor.this.getToolWindowPanel().getToolWindowTitleBar().getToolWindowTitleButtonPanel().getFocusable()) {
                    ToolWindowDescriptor.this.assignFocus();
                } else {
                    ToolWindowDescriptor.this.focusRequester.requestFocusInWindow();
                }
            } else {
                if (ToolWindowDescriptor.this.toolWindow.isActive()) {
                    ToolWindowDescriptor.this.getToolBar().deactiveTool(ToolWindowDescriptor.this.toolWindow);
                }
                if (ToolWindowDescriptor.this.toolWindow.isAutoHide() && ToolWindowDescriptor.this.toolWindow.getType() != ToolWindowType.EXTERN) {
                    ToolWindowDescriptor.this.toolWindow.setVisible(false);
                }
            }
            ToolWindowDescriptor.this.internalFocusValueAdjusting = false;
        }
    }

    public class ToolWindowDescriptorCleaner
    extends DefaultCleanerAggregator {
        public void cleanup() {
            super.cleanup();
            ToolWindowDescriptor.this.toolWindow.removePlafPropertyChangeListener(ToolWindowDescriptor.this);
            ((PropertyChangeEventSource)((Object)ToolWindowDescriptor.this.manager.getToolWindowManagerDescriptor())).removePlafPropertyChangeListener(ToolWindowDescriptor.this);
            ToolWindowDescriptor.this.floatingTypeDescriptor.removePropertyChangeListener(ToolWindowDescriptor.this);
            ToolWindowDescriptor.this.floatingLiveTypeDescriptor.removePropertyChangeListener(ToolWindowDescriptor.this);
            ToolWindowDescriptor.this.dockedTypeDescriptor.removePropertyChangeListener(ToolWindowDescriptor.this);
            ToolWindowDescriptor.this.slidingTypeDescriptor.removePropertyChangeListener(ToolWindowDescriptor.this);
            ToolWindowDescriptor.this.resetRepresentativeAnchor();
            ToolWindowDescriptor.this.toolWindow.cleanup();
            ToolWindowDescriptor.this.removeFloatingLiveWindow();
            if (ToolWindowDescriptor.this.toolWindowPanel != null) {
                ToolWindowDescriptor.this.toolWindowPanel.putClientProperty(ToolWindow.class, null);
                ToolWindowDescriptor.this.toolWindowPanel.removeAll();
            }
            ToolWindowDescriptor.this.toolWindow = null;
            ToolWindowDescriptor.this.manager = null;
        }
    }
}

