/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.io.socket;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.microedition.io.Connection;
import nl.lxtreme.ols.io.socket.ServerSocketConnectionImpl;
import nl.lxtreme.ols.io.socket.SocketConnectionImpl;
import nl.lxtreme.ols.io.socket.SocketOptions;
import org.osgi.service.io.ConnectionFactory;
import org.osgi.service.log.LogService;

public class SocketConnectionFactory
implements ConnectionFactory {
    public static final String SCHEME = "socket";
    private volatile LogService logService;

    public Connection createConnection(String aName, int aMode, boolean aTimeouts) throws IOException {
        try {
            SocketOptions options = new SocketOptions(aName);
            return this.createSocketConnection(options);
        }
        catch (IllegalArgumentException exception) {
            throw new IOException("Invalid URI!", exception);
        }
    }

    private Connection createSocketConnection(SocketOptions aOptions) throws UnknownHostException, IOException, SocketException {
        if (aOptions.isRemoteSocket()) {
            this.logService.log(4, "Opening socket to " + aOptions.getAddress() + ":" + aOptions.getPort());
            Socket socket = new Socket(aOptions.getAddress(), aOptions.getPort());
            socket.setSoTimeout(aOptions.getTimeout());
            return new SocketConnectionImpl(socket);
        }
        this.logService.log(4, "Opening server socket on " + aOptions.getPort());
        ServerSocket socket = new ServerSocket(aOptions.getPort());
        socket.setSoTimeout(aOptions.getTimeout());
        return new ServerSocketConnectionImpl(socket);
    }
}

