/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.device.test;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import nl.lxtreme.ols.api.Configurable;
import nl.lxtreme.ols.api.UserSettings;
import nl.lxtreme.ols.util.swing.StandardActionFactory;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;

public class TestDeviceDialog
extends JDialog
implements Configurable,
StandardActionFactory.CloseAction.Closeable {
    private static final long serialVersionUID = 1L;
    static final String[] DATA_FUNCTIONS = new String[]{"Sawtooth", "All zeros", "Sine", "odd-even", "0x55-0xAA", "Random", "I2C sample", "1-Wire sample", "Manchester encoded"};
    static final Integer[] CHANNELS = new Integer[]{1, 4, 8, 16, 32};
    static final Integer[] DATA_LENGTH = new Integer[]{16, 256, 1024, 4096, 8192, 16384, 32768, 65536, 131072};
    private boolean setupConfirmed = false;
    private String dataFunction;
    private int channels;
    private int dataLength;
    private JComboBox dataFunctionCombo;
    private JComboBox channelsCombo;
    private JComboBox dataLengthCombo;

    public TestDeviceDialog(Window aParent) {
        super(aParent, "Test capture settings", Dialog.ModalityType.DOCUMENT_MODAL);
        this.initDialog();
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    public int getChannels() {
        return this.channels;
    }

    public String getDataFunction() {
        return this.dataFunction;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void readPreferences(UserSettings aSettings) {
        this.dataFunctionCombo.setSelectedIndex(aSettings.getInt("dataFunction", 6));
        this.channelsCombo.setSelectedIndex(aSettings.getInt("channels", 2));
        this.dataLengthCombo.setSelectedIndex(aSettings.getInt("dataLength", 5));
    }

    public boolean showDialog() {
        this.setupConfirmed = false;
        this.setVisible(true);
        return this.setupConfirmed;
    }

    public void writePreferences(UserSettings aSettings) {
        aSettings.putInt("channels", this.channelsCombo.getSelectedIndex());
        aSettings.putInt("dataFunction", this.dataFunctionCombo.getSelectedIndex());
        aSettings.putInt("dataLength", this.dataLengthCombo.getSelectedIndex());
    }

    final void confirmAndCloseDialog() {
        this.setupConfirmed = true;
        this.channels = (Integer)this.channelsCombo.getSelectedItem();
        this.dataFunction = (String)this.dataFunctionCombo.getSelectedItem();
        this.dataLength = (Integer)this.dataLengthCombo.getSelectedItem();
        this.close();
    }

    private JPanel createContents() {
        this.dataFunctionCombo = new JComboBox<String>(DATA_FUNCTIONS);
        this.channelsCombo = new JComboBox<Integer>(CHANNELS);
        this.dataLengthCombo = new JComboBox<Integer>(DATA_LENGTH);
        Insets labelInsets = new Insets(4, 4, 4, 2);
        Insets compInsets = new Insets(4, 2, 4, 4);
        JPanel result = new JPanel(new GridBagLayout());
        result.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        result.add((Component)new JLabel("Data function"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 512, 2, labelInsets, 0, 0));
        result.add((Component)this.dataFunctionCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 768, 2, compInsets, 0, 0));
        result.add((Component)new JLabel("Channels"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 512, 2, labelInsets, 0, 0));
        result.add((Component)this.channelsCombo, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 768, 2, compInsets, 0, 0));
        result.add((Component)new JLabel("Data length"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 512, 2, labelInsets, 0, 0));
        result.add((Component)this.dataLengthCombo, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 768, 2, compInsets, 0, 0));
        return result;
    }

    private void initDialog() {
        JPanel contents = this.createContents();
        JButton closeButton = StandardActionFactory.createCloseButton();
        JButton okButton = new JButton("Ok");
        okButton.setPreferredSize(closeButton.getPreferredSize());
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                TestDeviceDialog.this.confirmAndCloseDialog();
            }
        });
        JComponent buttonPane = SwingComponentUtils.createButtonPane((JButton[])new JButton[]{okButton, closeButton});
        SwingComponentUtils.setupDialogContentPane((JDialog)this, (Component)contents, (Component)buttonPane, (JButton)okButton);
    }
}

