/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingWorker;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.Channel;
import nl.lxtreme.ols.api.data.Cursor;
import nl.lxtreme.ols.api.data.Edge;
import nl.lxtreme.ols.client.actionmanager.IActionManager;
import nl.lxtreme.ols.client.actionmanager.IManagedAction;
import nl.lxtreme.ols.client.signaldisplay.ICursorChangeListener;
import nl.lxtreme.ols.client.signaldisplay.IMeasurementListener;
import nl.lxtreme.ols.client.signaldisplay.IToolWindow;
import nl.lxtreme.ols.client.signaldisplay.MeasurementInfo;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;
import nl.lxtreme.ols.client.signaldisplay.model.SignalDiagramModel;
import nl.lxtreme.ols.client.signaldisplay.signalelement.ISignalElementChangeListener;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElement;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElementManager;
import nl.lxtreme.ols.client.signaldisplay.util.CursorFlagTextFormatter;
import nl.lxtreme.ols.client.signaldisplay.view.AbstractViewLayer;
import nl.lxtreme.ols.client.signaldisplay.view.ViewUtils;
import nl.lxtreme.ols.util.swing.SpringLayoutUtils;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;
import nl.lxtreme.ols.util.swing.component.JBusyIndicator;

public class MeasurementView
extends AbstractViewLayer
implements IToolWindow,
ISignalElementChangeListener,
ICursorChangeListener,
IMeasurementListener {
    public static final String ID = "Measure";
    private static final long serialVersionUID = 1L;
    private JCheckBox enableMeasurementMode;
    private JComboBox measureChannel;
    private JComboBox cursorA;
    private JComboBox cursorB;
    private JBusyIndicator indicator;
    private final JLabel mi_channel;
    private final JLabel mi_referenceLabel;
    private final JLabel mi_reference;
    private final JLabel mi_period;
    private final JLabel mi_frequency;
    private final JLabel mi_widthHigh;
    private final JLabel mi_widthLow;
    private final JLabel mi_dutyCycle;
    private final JLabel pci_timeLabel;
    private final JLabel pci_time;
    private final JLabel pci_frequency;
    private final JLabel pci_dutyCycle;
    private final JLabel pci_pulseCountLabel;
    private final JLabel pci_pulseCount;
    private volatile boolean listening;
    private volatile SignalMeasurerWorker signalMeasurerWorker;
    private final List<Component> comps = new ArrayList<Component>();

    public MeasurementView(SignalDiagramController aController) {
        super(aController);
        this.mi_channel = new JLabel();
        this.mi_referenceLabel = new JLabel("Time:");
        this.mi_referenceLabel.setHorizontalAlignment(4);
        this.mi_reference = new JLabel();
        this.mi_period = new JLabel();
        this.mi_frequency = new JLabel();
        this.mi_widthHigh = new JLabel();
        this.mi_widthLow = new JLabel();
        this.mi_dutyCycle = new JLabel();
        this.pci_timeLabel = new JLabel();
        this.pci_timeLabel.setHorizontalAlignment(4);
        this.pci_time = new JLabel();
        this.pci_frequency = new JLabel();
        this.pci_dutyCycle = new JLabel();
        this.pci_pulseCountLabel = new JLabel("# of pulses:");
        this.pci_pulseCountLabel.setHorizontalAlignment(4);
        this.pci_pulseCount = new JLabel();
        this.initComponent();
        this.listening = true;
    }

    public static MeasurementView create(SignalDiagramController aController) {
        MeasurementView result = new MeasurementView(aController);
        aController.addChannelChangeListener(result);
        aController.addCursorChangeListener(result);
        aController.addMeasurementListener(result);
        return result;
    }

    @Override
    public void cursorAdded(Cursor aCursor) {
        if (this.listening) {
            this.updateCursorModels();
        }
    }

    @Override
    public void cursorChanged(String aPropertyName, Cursor aOldCursor, Cursor aNewCursor) {
        if (this.listening && !"color".equals(aPropertyName)) {
            this.updateCursorModels();
        }
    }

    @Override
    public void cursorRemoved(Cursor aOldCursor) {
        if (this.listening) {
            this.updateCursorModels();
        }
    }

    @Override
    public void cursorsInvisible() {
        if (this.listening) {
            this.updateCursorModels();
        }
        this.setState(false);
    }

    @Override
    public void cursorsVisible() {
        if (this.listening) {
            this.updateCursorModels();
        }
        this.setState(true);
    }

    @Override
    public void disableMeasurementMode() {
        if (this.listening) {
            this.updateCursorModels();
        }
        this.setState(false);
    }

    @Override
    public void enableMeasurementMode() {
        if (this.listening) {
            this.updateCursorModels();
        }
        this.setState(true);
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void groupStructureChanged(Collection<SignalElement> aSignalElements) {
        if (this.listening) {
            this.updateChannelModel(this.getAllChannels(aSignalElements));
        }
    }

    @Override
    public void handleMeasureEvent(MeasurementInfo aEvent) {
        this.updateMeasurementInformation(aEvent);
        SwingComponentUtils.invokeOnEDT((Runnable)new Runnable(){

            @Override
            public void run() {
                MeasurementView.this.repaint(50L);
            }
        });
    }

    @Override
    public boolean isListening() {
        return this.listening;
    }

    @Override
    public void signalElementMoved(ISignalElementChangeListener.ElementMoveEvent aEvent) {
    }

    final Collection<Channel> getAllChannels() {
        return this.getAllChannels(this.getSignalElementManager().getAllElements());
    }

    final SignalDiagramModel getSignalDiagramModel() {
        return this.getController().getSignalDiagramModel();
    }

    final void updateMeasurementInformation(MeasurementInfo aMeasurementInfo) {
        String channelId = "-";
        String referenceLabel = "Time:";
        String reference = "-";
        String totalWidth = "-";
        String frequency = "-";
        String pwHigh = "-";
        String pwLow = "-";
        String dc = "-";
        boolean hasTimingData = true;
        if (aMeasurementInfo != null) {
            hasTimingData = aMeasurementInfo.hasTimingData();
            channelId = Integer.toString(aMeasurementInfo.getChannelIndex());
            if (aMeasurementInfo.getChannelLabel() != null) {
                channelId = channelId.concat(", ").concat(aMeasurementInfo.getChannelLabel());
            }
            reference = ViewUtils.formatReference(hasTimingData, aMeasurementInfo.getReferenceTime());
            if (hasTimingData) {
                totalWidth = ViewUtils.formatTime(aMeasurementInfo.getTotalTime());
                frequency = ViewUtils.formatPeriodAsFrequency(aMeasurementInfo.getTotalTime());
                pwHigh = ViewUtils.formatTime(aMeasurementInfo.getHighTime());
                pwLow = ViewUtils.formatTime(aMeasurementInfo.getLowTime());
                dc = ViewUtils.formatDutyCycle(aMeasurementInfo.getDutyCycle());
            } else {
                referenceLabel = "State:";
            }
        }
        this.mi_channel.setText(channelId);
        this.mi_referenceLabel.setText(referenceLabel);
        this.mi_reference.setText(reference);
        this.mi_frequency.setText(frequency);
        this.mi_period.setText(totalWidth);
        this.mi_widthHigh.setText(pwHigh);
        this.mi_widthLow.setText(pwLow);
        this.mi_dutyCycle.setText(dc);
    }

    final void updatePulseCountInformation(PulseCountInfo aPulseCountInfo) {
        boolean hasTimingData = true;
        boolean hasPulses = false;
        String timeTextLabel = "\u0394T (B-A):";
        String timeText = "-";
        String frequencyText = "-";
        String dutyCycleText = "-";
        String pulseCountLabel = "Pulses:";
        String pulseCountText = "-";
        if (aPulseCountInfo != null) {
            hasTimingData = aPulseCountInfo.hasTimingData;
            boolean bl = hasPulses = aPulseCountInfo.pulseCount != 0;
            if (hasTimingData) {
                timeText = ViewUtils.formatTime(aPulseCountInfo.measureTime);
                pulseCountText = String.format("%d (\u2191%d, \u2193%d)", aPulseCountInfo.pulseCount, aPulseCountInfo.risingEdgeCount, aPulseCountInfo.fallingEdgeCount);
                if (hasPulses) {
                    frequencyText = ViewUtils.formatFrequency(aPulseCountInfo.getFrequency());
                    dutyCycleText = ViewUtils.formatDutyCycle(aPulseCountInfo.getDutyCycle());
                }
            } else {
                timeTextLabel = "\u0394S (B-A):";
                timeText = Integer.toString(aPulseCountInfo.measureTime.intValue());
                pulseCountLabel = "Transitions:";
                pulseCountText = String.format("%d", aPulseCountInfo.pulseCount);
                pulseCountText = String.format("%d (\u2191%d, \u2193%d)", aPulseCountInfo.totalEdgeCount, aPulseCountInfo.risingEdgeCount, aPulseCountInfo.fallingEdgeCount);
            }
        }
        this.pci_timeLabel.setText(timeTextLabel);
        this.pci_time.setText(timeText);
        this.pci_frequency.setText(frequencyText);
        this.pci_dutyCycle.setText(dutyCycleText);
        this.pci_pulseCountLabel.setText(pulseCountLabel);
        this.pci_pulseCount.setText(pulseCountText);
    }

    protected void updateChannelModel(final Collection<Channel> aChannels) {
        SwingComponentUtils.invokeOnEDT((Runnable)new Runnable(){

            @Override
            public void run() {
                MeasurementView.this.updateChannelComboBoxModel(MeasurementView.this.measureChannel, aChannels);
                MeasurementView.this.updatePulseCountInformation(null);
                MeasurementView.this.updateMeasurementInfo();
                MeasurementView.this.repaint(50L);
            }
        });
    }

    protected void updateCursorModels() {
        SwingComponentUtils.invokeOnEDT((Runnable)new Runnable(){

            @Override
            public void run() {
                MeasurementView.this.updateCursorComboBoxModel(MeasurementView.this.cursorA);
                MeasurementView.this.updateCursorComboBoxModel(MeasurementView.this.cursorB);
                MeasurementView.this.updatePulseCountInformation(null);
                MeasurementView.this.updateMeasurementInfo();
                MeasurementView.this.repaint(50L);
            }
        });
    }

    private boolean canPerformMeasurement() {
        if (!this.getController().getSignalDiagramModel().isMeasurementMode()) {
            return false;
        }
        Channel channel = (Channel)this.measureChannel.getSelectedItem();
        if (channel == null || !channel.isEnabled()) {
            return false;
        }
        Cursor selectedCursorA = (Cursor)this.cursorA.getSelectedItem();
        if (selectedCursorA != null && !selectedCursorA.isDefined()) {
            return false;
        }
        Cursor selectedCursorB = (Cursor)this.cursorB.getSelectedItem();
        if (selectedCursorB != null && !selectedCursorB.isDefined()) {
            return false;
        }
        if (selectedCursorA != null && selectedCursorB != null) {
            return selectedCursorA != selectedCursorB;
        }
        return true;
    }

    private Collection<Channel> getAllChannels(Collection<SignalElement> aSignalElements) {
        ArrayList<Channel> channels = new ArrayList<Channel>();
        for (SignalElement element : aSignalElements) {
            if (!element.isDigitalSignal()) continue;
            channels.add(element.getChannel());
        }
        return channels;
    }

    private SignalElementManager getSignalElementManager() {
        return this.getSignalDiagramModel().getSignalElementManager();
    }

    private void initComponent() {
        IActionManager actionManager = this.getController().getActionManager();
        IManagedAction enableMeasurementModeAction = actionManager.getAction("SetMeasurementMode");
        this.enableMeasurementMode = new JCheckBox(enableMeasurementModeAction);
        this.enableMeasurementMode.setText("");
        this.measureChannel = this.updateChannelComboBoxModel(new JComboBox(), Collections.<Channel>emptyList());
        this.measureChannel.setRenderer(new ChannelComboBoxRenderer());
        this.measureChannel.addActionListener(new CursorActionListener());
        this.measureChannel.putClientProperty("JComponent.sizeVariant", "small");
        this.measureChannel.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.measureChannel.setEnabled(false);
        this.cursorA = this.updateCursorComboBoxModel(new JComboBox());
        this.cursorA.setRenderer(new CursorComboBoxRenderer());
        this.cursorA.addActionListener(new ChannelActionListener());
        this.cursorA.putClientProperty("JComponent.sizeVariant", "small");
        this.cursorA.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.cursorA.setEnabled(false);
        this.cursorB = this.updateCursorComboBoxModel(new JComboBox());
        this.cursorB.setRenderer(new CursorComboBoxRenderer());
        this.cursorB.addActionListener(new ChannelActionListener());
        this.cursorB.putClientProperty("JComponent.sizeVariant", "small");
        this.cursorB.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.cursorB.setEnabled(false);
        this.indicator = new JBusyIndicator();
        this.indicator.setVisible(false);
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.setName("Measurement");
        JPanel panel = new JPanel(new SpringLayout());
        SpringLayoutUtils.addSeparator((Container)panel, (String)"Measurement");
        panel.add(SwingComponentUtils.createRightAlignedLabel((String)"Enabled"));
        panel.add(this.enableMeasurementMode);
        this.comps.add(panel.add(SwingComponentUtils.createRightAlignedLabel((String)"Channel:")));
        this.comps.add(panel.add(this.mi_channel));
        this.comps.add(panel.add(this.mi_referenceLabel));
        this.comps.add(panel.add(this.mi_reference));
        this.comps.add(panel.add(SwingComponentUtils.createRightAlignedLabel((String)"Period:")));
        this.comps.add(panel.add(this.mi_period));
        this.comps.add(panel.add(SwingComponentUtils.createRightAlignedLabel((String)"Frequency:")));
        this.comps.add(panel.add(this.mi_frequency));
        this.comps.add(panel.add(SwingComponentUtils.createRightAlignedLabel((String)"Width (H):")));
        this.comps.add(panel.add(this.mi_widthHigh));
        this.comps.add(panel.add(SwingComponentUtils.createRightAlignedLabel((String)"Width (L):")));
        this.comps.add(panel.add(this.mi_widthLow));
        this.comps.add(panel.add(SwingComponentUtils.createRightAlignedLabel((String)"Duty cycle:")));
        this.comps.add(panel.add(this.mi_dutyCycle));
        SpringLayoutUtils.addSeparator((Container)panel, (String)"Pulse counter");
        this.comps.add(panel.add(SwingComponentUtils.createRightAlignedLabel((String)"Channel:")));
        this.comps.add(panel.add(this.measureChannel));
        this.comps.add(panel.add(SwingComponentUtils.createRightAlignedLabel((String)"Cursor A:")));
        this.comps.add(panel.add(this.cursorA));
        this.comps.add(panel.add(SwingComponentUtils.createRightAlignedLabel((String)"Cursor B:")));
        this.comps.add(panel.add(this.cursorB));
        this.comps.add(panel.add(this.pci_pulseCountLabel));
        this.comps.add(panel.add(this.pci_pulseCount));
        this.comps.add(panel.add(this.pci_timeLabel));
        this.comps.add(panel.add(this.pci_time));
        this.comps.add(panel.add(SwingComponentUtils.createRightAlignedLabel((String)"Frequency:")));
        this.comps.add(panel.add(this.pci_frequency));
        this.comps.add(panel.add(SwingComponentUtils.createRightAlignedLabel((String)"Duty cycle:")));
        this.comps.add(panel.add(this.pci_dutyCycle));
        panel.add(new JLabel(""));
        panel.add((Component)this.indicator);
        SpringLayoutUtils.makeEditorGrid((Container)panel, (int)10, (int)10);
        this.setState(this.enableMeasurementMode.isSelected());
        this.updateMeasurementInformation(null);
        this.updatePulseCountInformation(null);
        this.add((Component)panel, "North");
    }

    private void setState(final boolean aEnabled) {
        SwingComponentUtils.invokeOnEDT((Runnable)new Runnable(){

            @Override
            public void run() {
                for (Component label : MeasurementView.this.comps) {
                    label.setEnabled(aEnabled);
                }
            }
        });
    }

    private JComboBox updateChannelComboBoxModel(JComboBox aComboBox, Collection<Channel> aChannels) {
        DefaultComboBoxModel<Channel> model = new DefaultComboBoxModel<Channel>(new Vector<Channel>(aChannels));
        Object oldSelectedItem = aComboBox.getSelectedItem();
        aComboBox.setModel(model);
        aComboBox.setSelectedItem(oldSelectedItem);
        return aComboBox;
    }

    private JComboBox updateCursorComboBoxModel(JComboBox aComboBox) {
        Cursor[] cursors = this.getSignalDiagramModel().getDefinedCursors();
        DefaultComboBoxModel<Cursor> model = new DefaultComboBoxModel<Cursor>(cursors);
        Object oldSelectedItem = aComboBox.getSelectedItem();
        aComboBox.setModel(model);
        aComboBox.setSelectedItem(oldSelectedItem);
        return aComboBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMeasurementInfo() {
        this.listening = false;
        try {
            if (this.canPerformMeasurement() && (this.signalMeasurerWorker == null || this.signalMeasurerWorker.isDone())) {
                this.indicator.setVisible(true);
                Channel channel = (Channel)this.measureChannel.getSelectedItem();
                Cursor cursorA = (Cursor)this.cursorA.getSelectedItem();
                Cursor cursorB = (Cursor)this.cursorB.getSelectedItem();
                this.signalMeasurerWorker = new SignalMeasurerWorker(channel, cursorA, cursorB);
                this.signalMeasurerWorker.execute();
            }
        }
        finally {
            this.listening = true;
        }
    }

    final class SignalMeasurerWorker
    extends SwingWorker<PulseCountInfo, Boolean> {
        private final int index;
        private final long startTimestamp;
        private final long endTimestamp;

        public SignalMeasurerWorker(Channel aChannel, Cursor aCursorA, Cursor aCursorB) {
            this.index = aChannel.getIndex();
            this.startTimestamp = aCursorA != null ? aCursorA.getTimestamp() : -1L;
            this.endTimestamp = aCursorB != null ? aCursorB.getTimestamp() : -1L;
        }

        @Override
        protected PulseCountInfo doInBackground() throws Exception {
            long end;
            SignalDiagramModel model = MeasurementView.this.getSignalDiagramModel();
            long start = this.startTimestamp;
            if (start < 0L) {
                start = model.getTimestamps()[0];
            }
            if ((end = this.endTimestamp) < 0L) {
                end = model.getAbsoluteLength();
            }
            return new SignalMeasurer(model.getCapturedData(), this.index, start, end).run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            try {
                MeasurementView.this.updatePulseCountInformation((PulseCountInfo)this.get());
                MeasurementView.this.repaint(50L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                MeasurementView.this.indicator.setVisible(false);
            }
        }
    }

    static final class SignalMeasurer {
        private final AcquisitionResult result;
        private final int mask;
        private final long startTimestamp;
        private final long endTimestamp;

        public SignalMeasurer(AcquisitionResult aResult, int aIndex, long aStartTimestamp, long aEndTimestamp) {
            this.result = aResult;
            this.mask = 1 << aIndex;
            this.startTimestamp = aStartTimestamp;
            this.endTimestamp = aEndTimestamp;
        }

        public PulseCountInfo run() {
            int startIdx = this.result.getSampleIndex(this.startTimestamp);
            int endIdx = this.result.getSampleIndex(this.endTimestamp);
            boolean hasTimingData = this.result.hasTimingData();
            int[] values = this.result.getValues();
            long[] timestamps = this.result.getTimestamps();
            int fallingEdgeCount = 0;
            long highTime = 0L;
            int risingEdgeCount = 0;
            long lowTime = 0L;
            int i = startIdx;
            long lastTransition = timestamps[i];
            int lastBitValue = values[i++] & this.mask;
            while (!Thread.currentThread().isInterrupted() && i <= endIdx) {
                int bitValue = values[i] & this.mask;
                Edge edge = Edge.toEdge((int)lastBitValue, (int)bitValue);
                if (!edge.isNone()) {
                    long periodTime = timestamps[i] - lastTransition;
                    lastTransition = timestamps[i];
                    if (edge.isRising()) {
                        ++risingEdgeCount;
                        lowTime += periodTime;
                    } else {
                        ++fallingEdgeCount;
                        highTime += periodTime;
                    }
                }
                lastBitValue = bitValue;
                ++i;
            }
            double measureTime = Math.abs((double)(this.endTimestamp - this.startTimestamp) / (double)this.result.getSampleRate());
            return new PulseCountInfo(measureTime, risingEdgeCount, fallingEdgeCount, lowTime, highTime, this.result.getSampleRate(), hasTimingData);
        }
    }

    static final class PulseCountInfo {
        final Double measureTime;
        final Integer risingEdgeCount;
        final Integer fallingEdgeCount;
        final Integer totalEdgeCount;
        final long totalLowTime;
        final long totalHighTime;
        final Integer pulseCount;
        final int sampleRate;
        final boolean hasTimingData;

        public PulseCountInfo(double aMeasureTime, int aRisingEdgeCount, int aFallingEdgeCount, long aTotalLowTime, long aTotalHighTime, int aSampleRate, boolean aHasTimingData) {
            this.measureTime = aMeasureTime;
            this.risingEdgeCount = aRisingEdgeCount;
            this.fallingEdgeCount = aFallingEdgeCount;
            this.totalEdgeCount = aRisingEdgeCount + aFallingEdgeCount;
            this.totalLowTime = aTotalLowTime;
            this.totalHighTime = aTotalHighTime;
            this.pulseCount = this.totalEdgeCount / 2;
            this.sampleRate = aSampleRate;
            this.hasTimingData = aHasTimingData;
        }

        public double getDutyCycle() {
            double avgHighTime = this.getAveragePulseHighTime();
            double avgLowTime = this.getAveragePulseLowTime();
            return 100.0 * (avgHighTime / (avgHighTime + avgLowTime));
        }

        public Double getFrequency() {
            return (double)this.sampleRate / (this.getAveragePulseHighTime() + this.getAveragePulseLowTime());
        }

        private double getAveragePulseHighTime() {
            return (double)this.totalHighTime / this.fallingEdgeCount.doubleValue();
        }

        private double getAveragePulseLowTime() {
            return (double)this.totalLowTime / this.risingEdgeCount.doubleValue();
        }
    }

    final class CursorComboBoxRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        CursorComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList aList, Object aValue, int aIndex, boolean aIsSelected, boolean aCellHasFocus) {
            String text;
            if (aValue != null && aValue instanceof Cursor) {
                Cursor cursor = (Cursor)aValue;
                text = CursorFlagTextFormatter.getCursorFlagText(MeasurementView.this.getSignalDiagramModel(), cursor, CursorFlagTextFormatter.LabelStyle.LABEL_TIME);
            } else {
                text = aValue != null ? String.valueOf(aValue) : "";
            }
            return super.getListCellRendererComponent((JList<?>)aList, text, aIndex, aIsSelected, aCellHasFocus);
        }
    }

    final class CursorActionListener
    implements ActionListener {
        CursorActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent aEvent) {
            MeasurementView.this.updateCursorModels();
        }
    }

    static final class ChannelComboBoxRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        ChannelComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList aList, Object aValue, int aIndex, boolean aIsSelected, boolean aCellHasFocus) {
            StringBuilder sb = new StringBuilder();
            if (aValue != null && aValue instanceof Channel) {
                Channel channel = (Channel)aValue;
                sb.append(channel.getIndex());
                if (channel.hasName()) {
                    sb.append(", ").append(channel.getLabel());
                }
            }
            return super.getListCellRendererComponent((JList<?>)aList, sb.toString(), aIndex, aIsSelected, aCellHasFocus);
        }
    }

    final class ChannelActionListener
    implements ActionListener {
        ChannelActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent aEvent) {
            Collection<Channel> channelList = MeasurementView.this.getAllChannels();
            MeasurementView.this.updateChannelModel(channelList);
        }
    }
}

