/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client;

import java.awt.Component;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.UIManager;
import nl.lxtreme.ols.client.signaldisplay.IMeasurementListener;
import nl.lxtreme.ols.client.signaldisplay.IToolWindow;
import nl.lxtreme.ols.client.signaldisplay.MeasurementInfo;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;
import nl.lxtreme.ols.client.signaldisplay.view.AcquisitionDetailsView;
import nl.lxtreme.ols.client.signaldisplay.view.CursorDetailsView;
import nl.lxtreme.ols.client.signaldisplay.view.MeasurementView;
import nl.lxtreme.ols.util.HostUtils;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;
import org.noos.xing.mydoggy.DockedTypeDescriptor;
import org.noos.xing.mydoggy.RepresentativeAnchorDescriptor;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowGroup;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.ToolWindowTypeDescriptor;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;

public class DockController
implements IMeasurementListener {
    public static final String TW_ACQUISITION = "Acquisition";
    public static final String TW_MEASURE = "Measure";
    public static final String TW_CURSORS = "Cursor";
    public static final String GROUP_DEFAULT = "Default";
    private final File dataStorage;
    private final AtomicReference<MyDoggyToolWindowManager> windowManagerRef;
    private volatile boolean wasHidden = false;
    private AcquisitionDetailsView captureDetails;
    private CursorDetailsView cursorDetails;
    private MeasurementView measurementDetails;

    public DockController(File aDataStorage, final SignalDiagramController aSignalDiagramController) {
        this.dataStorage = aDataStorage;
        this.windowManagerRef = new AtomicReference();
        SwingComponentUtils.invokeOnEDT((Runnable)new Runnable(){

            @Override
            public void run() {
                DockController.this.captureDetails = AcquisitionDetailsView.create(aSignalDiagramController);
                DockController.this.cursorDetails = CursorDetailsView.create(aSignalDiagramController);
                DockController.this.measurementDetails = MeasurementView.create(aSignalDiagramController);
                MyDoggyToolWindowManager wm = new MyDoggyToolWindowManager(Locale.getDefault(), MyDoggyToolWindowManager.class.getClassLoader());
                wm.setDockableMainContentMode(false);
                DockController.this.windowManagerRef.compareAndSet(null, wm);
            }
        });
    }

    private static void tweakToolWindow(ToolWindow aWindow) {
        ToolWindowType[] types;
        RepresentativeAnchorDescriptor anchorDesc = aWindow.getRepresentativeAnchorDescriptor();
        anchorDesc.setTitle(aWindow.getTitle());
        anchorDesc.setPreviewEnabled(false);
        if (aWindow.getIcon() != null) {
            anchorDesc.setIcon(aWindow.getIcon());
        }
        for (ToolWindowType type : types = ToolWindowType.values()) {
            ToolWindowTypeDescriptor desc = aWindow.getTypeDescriptor(type);
            desc.setAnimating(false);
            desc.setAutoHide(false);
            desc.setEnabled(true);
            desc.setHideRepresentativeButtonOnVisible(false);
            desc.setIdVisibleOnTitleBar(false);
            desc.setTitleBarButtonsVisible(false);
            desc.setTitleBarVisible(false);
        }
        DockedTypeDescriptor desc = (DockedTypeDescriptor)aWindow.getTypeDescriptor(ToolWindowType.DOCKED);
        desc.setPopupMenuEnabled(false);
        aWindow.setAvailable(true);
        aWindow.setHideOnZeroTabs(false);
        aWindow.setVisible(UIManager.getBoolean("ols.show.tool.windows.default.boolean"));
    }

    @Override
    public void disableMeasurementMode() {
        ToolWindow toolWindow = this.getManager().getToolWindow((Object)TW_MEASURE);
        toolWindow.setVisible(this.wasHidden);
    }

    @Override
    public void enableMeasurementMode() {
        ToolWindow toolWindow = this.getManager().getToolWindow((Object)TW_MEASURE);
        this.wasHidden = toolWindow.isVisible();
        toolWindow.setVisible(true);
    }

    public Component get() {
        return this.getManager();
    }

    @Override
    public void handleMeasureEvent(MeasurementInfo aEvent) {
    }

    @Override
    public boolean isListening() {
        return true;
    }

    public void registerToolWindow(IToolWindow aToolWindow, String aGroupName) {
        MyDoggyToolWindowManager wm = this.getManager();
        ToolWindow tw = wm.registerToolWindow(aToolWindow.getId(), aToolWindow.getName(), aToolWindow.getIcon(), (Component)((Object)aToolWindow), ToolWindowAnchor.RIGHT);
        ToolWindowGroup group = wm.getToolWindowGroup(aGroupName);
        group.setImplicit(false);
        group.addToolWindow(tw);
        DockController.tweakToolWindow(tw);
    }

    public void setMainContent(Component aComponent) {
        this.getManager().setMainContent(aComponent);
    }

    final MyDoggyToolWindowManager getManager() {
        return this.windowManagerRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void start() {
        this.registerToolWindow(this.cursorDetails, GROUP_DEFAULT);
        this.registerToolWindow(this.captureDetails, GROUP_DEFAULT);
        this.registerToolWindow(this.measurementDetails, GROUP_DEFAULT);
        File dataFile = new File(this.dataStorage, "dock.settings");
        if (this.dataStorage == null || !dataFile.exists()) {
            return;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(dataFile);
            this.getManager().getPersistenceDelegate().apply((InputStream)fis);
        }
        catch (FileNotFoundException fileNotFoundException) {
            HostUtils.closeResource((Closeable)fis);
            catch (Throwable throwable) {
                HostUtils.closeResource(fis);
                throw throwable;
            }
        }
        HostUtils.closeResource((Closeable)fis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void stop() {
        if (this.dataStorage == null) {
            return;
        }
        File dataFile = new File(this.dataStorage, "dock.settings");
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(dataFile);
            this.getManager().getPersistenceDelegate().save((OutputStream)fos);
        }
        catch (FileNotFoundException fileNotFoundException) {
            HostUtils.closeResource((Closeable)fos);
            catch (Throwable throwable) {
                HostUtils.closeResource(fos);
                throw throwable;
            }
        }
        HostUtils.closeResource((Closeable)fos);
    }
}

