/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.action;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;
import nl.lxtreme.ols.client.signaldisplay.signalelement.ElementGroup;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElement;

public class SetSignalGroupVisibilityAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private final ElementGroup signalGroup;
    private final SignalDiagramController controller;
    private final SignalElement.SignalElementType elementType;

    public SetSignalGroupVisibilityAction(SignalDiagramController aController, SignalElement aSignalElement, SignalElement.SignalElementType aType) {
        boolean visible;
        String suffix;
        if (!aSignalElement.isSignalGroup()) {
            throw new IllegalArgumentException();
        }
        this.signalGroup = aSignalElement.getGroup();
        this.controller = aController;
        this.elementType = aType;
        if (aType == SignalElement.SignalElementType.DIGITAL_SIGNAL) {
            suffix = "digital signals";
            visible = this.signalGroup.isShowDigitalSignals();
        } else if (aType == SignalElement.SignalElementType.ANALOG_SIGNAL) {
            suffix = "analog signal";
            visible = this.signalGroup.isShowAnalogSignal();
        } else if (aType == SignalElement.SignalElementType.GROUP_SUMMARY) {
            suffix = "group summary";
            visible = this.signalGroup.isShowGroupSummary();
        } else {
            throw new InternalError("Unknown signal element?!");
        }
        String prefix = visible ? "Hide" : "Show";
        this.putValue("Name", prefix.concat(" ").concat(suffix));
    }

    @Override
    public void actionPerformed(ActionEvent aEvent) {
        if (this.elementType == SignalElement.SignalElementType.DIGITAL_SIGNAL) {
            this.signalGroup.setShowDigitalSignals(!this.signalGroup.isShowDigitalSignals());
        } else if (this.elementType == SignalElement.SignalElementType.ANALOG_SIGNAL) {
            this.signalGroup.setShowAnalogSignal(!this.signalGroup.isShowAnalogSignal());
        } else if (this.elementType == SignalElement.SignalElementType.GROUP_SUMMARY) {
            this.signalGroup.setShowGroupSummary(!this.signalGroup.isShowGroupSummary());
        }
        this.controller.recalculateDimensions();
    }
}

