/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.osgi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import nl.lxtreme.ols.util.ColorUtils;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;

public class UIColorSchemeManager
implements ManagedServiceFactory {
    public static final String PID = "ols.ui.colorscheme";
    private static final String SCHEME_NAME = "ols.color.scheme.name";
    private final ConcurrentMap<String, Properties> colorSchemes = new ConcurrentHashMap<String, Properties>();

    public void deleted(String aPid) {
        this.colorSchemes.remove(aPid);
    }

    public Properties getColorScheme(String aName) {
        for (Properties props : this.colorSchemes.values()) {
            if (!props.getProperty(SCHEME_NAME).equals(aName)) continue;
            Properties result = new Properties();
            result.putAll((Map<?, ?>)props);
            return result;
        }
        return null;
    }

    public int getColorSchemeCount() {
        return this.colorSchemes.size();
    }

    public List<String> getColorSchemes() {
        ArrayList<String> result = new ArrayList<String>();
        for (Properties props : this.colorSchemes.values()) {
            result.add(props.getProperty(SCHEME_NAME));
        }
        Collections.sort(result);
        return result;
    }

    public String getName() {
        return "Color Scheme manager";
    }

    public void updated(String aPid, Dictionary aProperties) throws ConfigurationException {
        this.colorSchemes.put(aPid, this.parseColorScheme(aProperties));
    }

    private Properties parseColorScheme(Dictionary aDictionary) throws ConfigurationException {
        String name = (String)aDictionary.get(SCHEME_NAME);
        if (name == null || "".equals(name.trim())) {
            throw new ConfigurationException(SCHEME_NAME, "Missing or invalid value!");
        }
        Properties properties = new Properties();
        Enumeration keyEnum = aDictionary.keys();
        while (keyEnum.hasMoreElements()) {
            String key = (String)keyEnum.nextElement();
            if (!key.startsWith("ols.")) continue;
            Object value = aDictionary.get(key);
            if (key.endsWith(".color")) {
                value = ColorUtils.parseColor((String)value.toString());
            }
            properties.put(key, value);
        }
        return properties;
    }
}

