/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.util;

import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import javax.swing.SwingUtilities;

public abstract class AccumulatingRunnable<T>
implements Runnable {
    private Deque<T> arguments = null;

    public final synchronized void add(T ... args) {
        boolean isSubmitted = true;
        if (this.arguments == null) {
            isSubmitted = false;
            this.arguments = new LinkedList<T>();
        }
        Collections.addAll(this.arguments, args);
        if (!isSubmitted) {
            this.submit();
        }
    }

    @Override
    public final void run() {
        this.run(this.flush());
    }

    protected abstract void run(Deque<T> var1);

    private synchronized Deque<T> flush() {
        Deque<T> list = this.arguments;
        this.arguments = null;
        return list;
    }

    private void submit() {
        SwingUtilities.invokeLater(this);
    }
}

