/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.api.util;

public enum FrequencyUnit {
    MiHZ("m", 0.001),
    HZ("", 1.0),
    KHZ("k", 1000.0),
    MHZ("M", 1000000.0),
    GHZ("G", 1.0E9),
    THZ("T", 1.0E12);

    public static final double ZERO_THRESHOLD = 1.0E-5;
    private static final String BASE_UNIT = "Hz";
    private final String displayName;
    private final double factor;

    private FrequencyUnit(String aPrefix, double aFactor) {
        this.displayName = aPrefix.concat(BASE_UNIT);
        this.factor = aFactor;
    }

    public static String format(double aFrequency) {
        return FrequencyUnit.toUnit(aFrequency).format(aFrequency, 3);
    }

    public static FrequencyUnit toUnit(double aFrequency) {
        int i;
        FrequencyUnit[] freqs = FrequencyUnit.values();
        double frequency = Math.abs(aFrequency);
        for (i = freqs.length - 1; i >= 0 && !(frequency >= freqs[i].getFactor()); --i) {
        }
        return freqs[Math.max(i, 0)];
    }

    public String format(double aFrequency, int aScale) {
        if (Math.abs(aFrequency) < 1.0E-5 && this != HZ) {
            return HZ.format(0.0, aScale);
        }
        Double frequency = aFrequency / this.getFactor();
        String format = String.format("%%.%df%%s", aScale);
        return String.format(format, frequency, this.getDisplayName());
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public double getFactor() {
        return this.factor;
    }
}

