/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.spi;

import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.BaseDataSet;
import nl.lxtreme.ols.tool.spi.SPIData;

public final class SPIDataSet
extends BaseDataSet<SPIData> {
    public static final String SPI_CS_LOW = "CS_LOW";
    public static final String SPI_CS_HIGH = "CS_HIGH";
    public static final String SPI_MOSI = "MOSI";
    public static final String SPI_MISO = "MISO";
    public static final String SPI_SCK = "SCK";
    public static final String SPI_CS = "/CS";

    public SPIDataSet(int aStartOfDecode, int aEndOfDecode, AcquisitionResult aData) {
        super(aStartOfDecode, aEndOfDecode, aData);
    }

    public void reportCSHigh(int aChannelIdx, int aSampleIdx) {
        int idx = this.size();
        this.addData(new SPIData(idx, aChannelIdx, SPI_CS_HIGH, aSampleIdx));
    }

    public void reportCSLow(int aChannelIdx, int aSampleIdx) {
        int idx = this.size();
        this.addData(new SPIData(idx, aChannelIdx, SPI_CS_LOW, aSampleIdx));
    }

    public void reportMisoData(int aChannelIdx, int aStartIdx, int aEndIdx, int aDataValue) {
        int idx = this.size();
        this.addData(new SPIData(idx, aChannelIdx, SPI_MISO, aDataValue, aStartIdx, aEndIdx));
    }

    public void reportMosiData(int aChannelIdx, int aStartIdx, int aEndIdx, int aDataValue) {
        int idx = this.size();
        this.addData(new SPIData(idx, aChannelIdx, SPI_MOSI, aDataValue, aStartIdx, aEndIdx));
    }
}

