/*
 * Decompiled with CFR 0.152.
 */
package org.sump.device.logicsniffer.profile;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.sump.device.logicsniffer.profile.DeviceProfile;

public class DeviceProfileManager
implements ManagedServiceFactory {
    public static final String SERVICE_PID = "ols.profile";
    private static final String DEFAULT_PROFILE_TYPE = "OLS";
    private final ConcurrentMap<String, DeviceProfile> profiles = new ConcurrentHashMap<String, DeviceProfile>();

    public void deleted(String aPid) {
        this.profiles.remove(aPid);
    }

    public DeviceProfile findProfile(String aIdentifier) {
        List<DeviceProfile> allProfiles = this.getProfiles();
        boolean allowWildcardMatch = false;
        for (int tries = 0; tries < 2; ++tries) {
            for (DeviceProfile profile : allProfiles) {
                String[] metadataKeys = profile.getDeviceMetadataKeys();
                if (!this.matches(aIdentifier, allowWildcardMatch, metadataKeys)) continue;
                return profile;
            }
            allowWildcardMatch = true;
        }
        return null;
    }

    public DeviceProfile getDefaultProfile() {
        return this.getProfile(DEFAULT_PROFILE_TYPE);
    }

    public String getName() {
        return "LogicSniffer device profile factory";
    }

    public DeviceProfile getProfile(String aType) {
        List<DeviceProfile> allProfiles = this.getProfiles();
        for (DeviceProfile profile : allProfiles) {
            if (!aType.equals(profile.getType())) continue;
            return profile;
        }
        return null;
    }

    public List<DeviceProfile> getProfiles() {
        ArrayList<DeviceProfile> result = new ArrayList<DeviceProfile>();
        result.addAll(this.profiles.values());
        return result;
    }

    public int getSize() {
        return this.profiles.size();
    }

    public void updated(String aPid, Dictionary aProperties) throws ConfigurationException {
        DeviceProfile profile = (DeviceProfile)this.profiles.get(aPid);
        if (profile == null) {
            profile = new DeviceProfile();
            this.profiles.putIfAbsent(aPid, profile);
        }
        profile.setProperties(aProperties);
    }

    private boolean matches(String aIdentifier, boolean aAllowWildcard, String ... aMetadataKeys) {
        for (String metadataKey : aMetadataKeys) {
            if (aIdentifier.startsWith(metadataKey)) {
                return true;
            }
            if (!aAllowWildcard || !"*".equals(metadataKey)) continue;
            return true;
        }
        return false;
    }
}

