/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.transparency;

import java.awt.Toolkit;
import java.awt.Window;
import org.noos.xing.mydoggy.plaf.ui.transparency.TransparencyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowTransparencyManager
implements TransparencyManager<Window> {
    private static boolean LIBRARIES_LOADED;

    private static native boolean isAlphaModeEnabledNative(Window var0);

    private static native void setAlphaModeEnabledNative(Window var0, boolean var1);

    private static native void setAlphaModeRatioNative(Window var0, float var1);

    @Override
    public boolean isServiceAvailable() {
        return LIBRARIES_LOADED;
    }

    @Override
    public synchronized void setAlphaModeRatio(Window window, float transparency) {
        if (LIBRARIES_LOADED) {
            if (WindowTransparencyManager.isAlphaModeEnabledNative(window)) {
                if (transparency == 0.0f) {
                    WindowTransparencyManager.setAlphaModeRatioNative(window, 0.0f);
                    WindowTransparencyManager.setAlphaModeEnabledNative(window, false);
                } else {
                    WindowTransparencyManager.setAlphaModeRatioNative(window, transparency);
                }
            } else {
                if (transparency == 0.0f) {
                    return;
                }
                WindowTransparencyManager.setAlphaModeEnabledNative(window, true);
                WindowTransparencyManager.setAlphaModeRatioNative(window, transparency);
            }
        }
    }

    @Override
    public synchronized boolean isAlphaModeEnabled(Window window) {
        return LIBRARIES_LOADED && WindowTransparencyManager.isAlphaModeEnabledNative(window);
    }

    static {
        try {
            Toolkit.getDefaultToolkit();
            System.loadLibrary("jawt");
            System.loadLibrary("TransparencyManager");
            LIBRARIES_LOADED = true;
        }
        catch (Throwable t) {
            LIBRARIES_LOADED = false;
        }
    }
}

