/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.look;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLabelUI;
import org.noos.xing.mydoggy.Dockable;
import org.noos.xing.mydoggy.plaf.cleaner.Cleaner;
import org.noos.xing.mydoggy.plaf.ui.DockableDescriptor;
import org.noos.xing.mydoggy.plaf.ui.animation.AbstractAnimation;
import org.noos.xing.mydoggy.plaf.ui.cmp.ContentRepresentativeAnchor;
import org.noos.xing.mydoggy.plaf.ui.cmp.border.LineBorder;
import org.noos.xing.mydoggy.plaf.ui.drag.RepresentativeAnchorDragListener;
import org.noos.xing.mydoggy.plaf.ui.util.GraphicsUtil;
import org.noos.xing.mydoggy.plaf.ui.util.MutableColor;
import org.noos.xing.mydoggy.plaf.ui.util.RemoveNotifyDragListener;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class ContentRepresentativeAnchorUI
extends MetalLabelUI
implements Cleaner {
    protected ContentRepresentativeAnchor contentRepresentativeAnchor;
    protected LineBorder labelBorder;
    protected DockableDescriptor descriptor;
    protected Dockable dockable;
    protected RepresentativeAnchorMouseAdapter adapter;
    protected Timer flashingTimer;
    protected int flasingDuration;
    protected boolean flashingState;
    protected MutableColor flashingAnimBackStart;
    protected MutableColor flashingAnimBackEnd;
    protected AbstractAnimation flashingAnimation;
    protected RemoveNotifyDragListener removeNotifyDragListener;

    public static ComponentUI createUI(JComponent c) {
        return new ContentRepresentativeAnchorUI();
    }

    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if ("flash".equals(propertyName)) {
            if (e.getNewValue() == Boolean.TRUE) {
                if (this.descriptor.isAvailable()) {
                    this.flasingDuration = SwingUtil.getInt(e, -1);
                    SwingUtil.repaint(this.contentRepresentativeAnchor);
                }
            } else if (this.flashingTimer != null) {
                this.flashingTimer.stop();
                this.flashingTimer = null;
                SwingUtil.repaint(this.contentRepresentativeAnchor);
            }
        }
    }

    public void cleanup() {
        this.uninstallUI(this.contentRepresentativeAnchor);
    }

    public void installUI(JComponent c) {
        this.contentRepresentativeAnchor = (ContentRepresentativeAnchor)c;
        this.descriptor = this.contentRepresentativeAnchor.getDockableDescriptor();
        this.dockable = this.descriptor.getDockable();
        this.flashingAnimation = new GradientAnimation();
        this.flashingAnimBackStart = new MutableColor(UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.inactive"));
        this.flashingAnimBackEnd = new MutableColor(UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.inactive"));
        this.flasingDuration = -1;
        super.installUI(c);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        if (this.flashingTimer != null) {
            this.flashingTimer.stop();
        }
        this.flashingTimer = null;
        this.descriptor = null;
        this.dockable = null;
        this.contentRepresentativeAnchor = null;
    }

    public void update(Graphics g, JComponent c) {
        c.setForeground(UIManager.getColor("ToolWindowRepresentativeAnchorUI.foreground"));
        if (this.dockable.isFlashing() && this.descriptor.isAvailable()) {
            this.updateAnchor(g, c, this.flashingAnimBackStart, this.flashingAnimBackEnd, false, true);
            if (this.flashingTimer == null) {
                this.flashingTimer = new Timer(600, new ActionListener(){
                    long start = 0L;

                    public void actionPerformed(ActionEvent e) {
                        if (this.start == 0L) {
                            this.start = System.currentTimeMillis();
                        }
                        boolean bl = ContentRepresentativeAnchorUI.this.flashingState = !ContentRepresentativeAnchorUI.this.flashingState;
                        if (ContentRepresentativeAnchorUI.this.flashingAnimation.isAnimating()) {
                            ContentRepresentativeAnchorUI.this.flashingAnimation.stop();
                        }
                        if (ContentRepresentativeAnchorUI.this.flashingState) {
                            ContentRepresentativeAnchorUI.this.flashingAnimation.show(new Object[0]);
                        } else {
                            ContentRepresentativeAnchorUI.this.flashingAnimation.hide(new Object[0]);
                        }
                        if (ContentRepresentativeAnchorUI.this.flasingDuration != -1 && System.currentTimeMillis() - this.start > (long)ContentRepresentativeAnchorUI.this.flasingDuration) {
                            ContentRepresentativeAnchorUI.this.dockable.setFlashing(false);
                        }
                    }
                });
                this.flashingState = true;
                this.flashingAnimation.show(new Object[0]);
            }
            if (!this.flashingTimer.isRunning()) {
                this.flashingTimer.start();
            }
        } else {
            if (this.flashingTimer != null) {
                this.flashingTimer.stop();
                this.flashingTimer = null;
            }
            this.updateAnchor(g, c, UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.active.start"), UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.active.end"), false, false);
        }
        this.paint(g, c);
    }

    protected void installDefaults(JLabel c) {
        super.installDefaults(c);
        this.flashingAnimation = new GradientAnimation();
        this.flasingDuration = -1;
        this.flashingAnimBackStart = new MutableColor(UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.inactive"));
        this.flashingAnimBackEnd = new MutableColor(UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.inactive"));
        this.labelBorder = new LineBorder(UIManager.getColor("ToolWindowRepresentativeAnchorUI.border.mouseOut"), 1, true, 3, 3);
        c.setBorder(this.labelBorder);
        c.setForeground(UIManager.getColor("ToolWindowRepresentativeAnchorUI.foreground"));
        String oldText = c.getText();
        if (oldText != null) {
            c.setText(null);
            c.setText(oldText);
        }
        if ((oldText = c.getToolTipText()) != null) {
            c.setToolTipText(null);
            c.setToolTipText(oldText);
        }
        SwingUtil.installFont(c, "ToolWindowRepresentativeAnchorUI.font");
    }

    protected void installListeners(JLabel c) {
        super.installListeners(c);
        String oldText = c.getText();
        if (oldText != null) {
            c.setText(null);
            c.setText(oldText);
        }
        if ((oldText = c.getToolTipText()) != null) {
            c.setToolTipText(null);
            c.setToolTipText(oldText);
        }
        this.adapter = new RepresentativeAnchorMouseAdapter();
        c.addMouseListener(this.adapter);
        c.addMouseMotionListener(this.adapter);
        this.removeNotifyDragListener = new RemoveNotifyDragListener(c, new RepresentativeAnchorDragListener(this.descriptor, c));
        this.descriptor.getManager().addRemoveNotifyListener(this.removeNotifyDragListener);
        this.dockable.addPropertyChangeListener(this);
        this.descriptor.getCleaner().addCleaner(this);
    }

    protected void uninstallListeners(JLabel c) {
        super.uninstallListeners(c);
        c.removeMouseListener(this.adapter);
        c.removeMouseMotionListener(this.adapter);
        this.removeNotifyDragListener.cleanup();
        this.descriptor.getManager().removeRemoveNotifyListener(this.removeNotifyDragListener);
        this.dockable.removePropertyChangeListener(this);
        this.descriptor.getCleaner().removeCleaner(this);
    }

    protected void updateAnchor(Graphics g, JComponent c, Color backgroundStart, Color backgroundEnd, boolean active, boolean flashing) {
        Rectangle r = c.getBounds();
        r.y = 0;
        r.x = 0;
        if (flashing || active) {
            GraphicsUtil.fillRect(g, r, backgroundStart, backgroundEnd, null, 1);
        } else {
            g.setColor(UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.inactive"));
            g.fillRect(0, 0, r.width, r.height);
        }
    }

    public class RepresentativeAnchorMouseAdapter
    extends MouseInputAdapter {
        public void mouseClicked(MouseEvent e) {
            ContentRepresentativeAnchorUI.this.contentRepresentativeAnchor.setBorder(ContentRepresentativeAnchorUI.this.labelBorder);
            ContentRepresentativeAnchorUI.this.labelBorder.setLineColor(UIManager.getColor("ToolWindowRepresentativeAnchorUI.border.mouseIn"));
            SwingUtil.repaint(ContentRepresentativeAnchorUI.this.contentRepresentativeAnchor);
            if (SwingUtilities.isLeftMouseButton(e)) {
                ContentRepresentativeAnchorUI.this.dockable.setMinimized(false);
            } else if (SwingUtilities.isRightMouseButton(e)) {
                // empty if block
            }
        }

        public void mouseEntered(MouseEvent e) {
            Component source = e.getComponent();
            ContentRepresentativeAnchorUI.this.labelBorder.setLineColor(UIManager.getColor("ToolWindowRepresentativeAnchorUI.border.mouseIn"));
            SwingUtil.repaint(source);
        }

        public void mouseExited(MouseEvent e) {
            Component source = e.getComponent();
            ContentRepresentativeAnchorUI.this.labelBorder.setLineColor(UIManager.getColor("ToolWindowRepresentativeAnchorUI.border.mouseOut"));
            SwingUtil.repaint(source);
        }

        public void mouseDragged(MouseEvent e) {
        }
    }

    public class GradientAnimation
    extends AbstractAnimation {
        public GradientAnimation() {
            super(600.0f);
        }

        protected float onAnimating(float animationPercent) {
            switch (this.getAnimationDirection()) {
                case INCOMING: {
                    GraphicsUtil.getInterpolatedColor(ContentRepresentativeAnchorUI.this.flashingAnimBackStart, UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.inactive"), UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.active.start"), animationPercent);
                    GraphicsUtil.getInterpolatedColor(ContentRepresentativeAnchorUI.this.flashingAnimBackEnd, UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.inactive"), UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.active.end"), animationPercent);
                    break;
                }
                case OUTGOING: {
                    GraphicsUtil.getInterpolatedColor(ContentRepresentativeAnchorUI.this.flashingAnimBackStart, UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.active.start"), UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.inactive"), animationPercent);
                    GraphicsUtil.getInterpolatedColor(ContentRepresentativeAnchorUI.this.flashingAnimBackEnd, UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.active.end"), UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.inactive"), animationPercent);
                }
            }
            SwingUtil.repaint(ContentRepresentativeAnchorUI.this.contentRepresentativeAnchor);
            return animationPercent;
        }

        protected void onFinishAnimation() {
            switch (this.getAnimationDirection()) {
                case INCOMING: {
                    ContentRepresentativeAnchorUI.this.flashingAnimBackStart.setRGB(UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.inactive"));
                    break;
                }
                case OUTGOING: {
                    ContentRepresentativeAnchorUI.this.flashingAnimBackStart.setRGB(UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.active.start"));
                }
            }
            SwingUtil.repaint(ContentRepresentativeAnchorUI.this.contentRepresentativeAnchor);
        }

        protected void onHide(Object ... params) {
            ContentRepresentativeAnchorUI.this.flashingAnimBackStart.setRGB(UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.active.start"));
            ContentRepresentativeAnchorUI.this.flashingAnimBackEnd.setRGB(UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.active.end"));
        }

        protected void onShow(Object ... params) {
            ContentRepresentativeAnchorUI.this.flashingAnimBackStart.setRGB(UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.inactive"));
            ContentRepresentativeAnchorUI.this.flashingAnimBackEnd.setRGB(UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.inactive"));
        }

        protected void onStartAnimation(AbstractAnimation.Direction direction) {
        }

        protected AbstractAnimation.Direction chooseFinishDirection(AbstractAnimation.Type type) {
            return type == AbstractAnimation.Type.SHOW ? AbstractAnimation.Direction.OUTGOING : AbstractAnimation.Direction.INCOMING;
        }
    }
}

