/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.io.serial;

import java.io.IOException;
import javax.microedition.io.Connection;
import nl.lxtreme.ols.io.serial.CommConnectionImpl;
import nl.lxtreme.ols.io.serial.CommPortOptions;
import org.osgi.service.io.ConnectionFactory;
import org.osgi.service.log.LogService;
import purejavacomm.CommPort;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;

public class CommConnectionFactory
implements ConnectionFactory {
    public static final String SCHEME = "comm";
    private static final int MAX_TRIES = 10;
    private static final String CONNECT_ID = CommConnectionFactory.class.getSimpleName();
    private volatile LogService logService;

    public Connection createConnection(String aName, int aMode, boolean aTimeouts) throws IOException {
        try {
            CommPortOptions options = new CommPortOptions(aName);
            SerialPort port = this.obtainSerialPort(options);
            port.setSerialPortParams(options.getBaudrate(), options.getDatabits(), options.getStopbits(), options.getParityMode());
            port.setFlowControlMode(options.getFlowControl());
            if (aTimeouts) {
                port.enableReceiveTimeout(options.getReceiveTimeout());
            }
            port.setRTS(true);
            port.setDTR(options.isDTR());
            CommConnectionImpl connection = new CommConnectionImpl(port);
            int openDelay = options.getOpenDelay();
            if (openDelay > 0) {
                Thread.sleep(openDelay);
            }
            return connection;
        }
        catch (IllegalArgumentException exception) {
            throw new IOException("Invalid URI!", exception);
        }
        catch (UnsupportedCommOperationException exception) {
            throw new IOException("Unsupported operation!", exception);
        }
        catch (NoSuchPortException exception) {
            throw new IOException("No such port!");
        }
        catch (InterruptedException exception) {
            throw new IOException("Interrupted while opening port!");
        }
    }

    private SerialPort getSerialPort(CommPortOptions aOptions) throws NoSuchPortException, PortInUseException, IOException {
        CommPortIdentifier commPortId = CommPortIdentifier.getPortIdentifier((String)aOptions.getPortName());
        if (commPortId.isCurrentlyOwned() && commPortId.getCurrentOwner() != CONNECT_ID) {
            throw new PortInUseException();
        }
        CommPort commPort = commPortId.open(CONNECT_ID, 2000);
        if (!(commPort instanceof SerialPort)) {
            throw new IOException("Not a serial port?!");
        }
        return (SerialPort)commPort;
    }

    private SerialPort obtainSerialPort(CommPortOptions aOptions) throws NoSuchPortException, IOException {
        int tries = 10;
        SerialPort port = null;
        while (tries-- >= 0 && port == null) {
            try {
                port = this.getSerialPort(aOptions);
            }
            catch (PortInUseException exception) {
                this.logService.log(4, "Port (still) in use!", (Throwable)exception);
            }
            catch (NoSuchPortException exception) {
                this.logService.log(4, "No such port!", (Throwable)exception);
                tries = -1;
            }
        }
        if (port == null) {
            throw new NoSuchPortException();
        }
        return port;
    }
}

