/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.view.renderer;

import java.awt.BasicStroke;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import nl.lxtreme.ols.client.signaldisplay.model.ChannelLabelsViewModel;
import nl.lxtreme.ols.client.signaldisplay.signalelement.ElementGroup;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElement;
import nl.lxtreme.ols.client.signaldisplay.view.renderer.BaseRenderer;

public class SignalElementInsertionPointRenderer
extends BaseRenderer {
    private static final int CHANNEL_ROW_MARKER_WIDTH = 100;
    private static final Stroke INDICATOR_STROKE = new BasicStroke(1.5f);
    private final ChannelLabelsViewModel model;
    private final SignalElement signalElement;
    private volatile Point dropPoint;

    public SignalElementInsertionPointRenderer(ChannelLabelsViewModel aModel, SignalElement aMovedChannel) {
        this.model = aModel;
        this.signalElement = aMovedChannel;
    }

    @Override
    public void setContext(Object ... aParameters) {
        if (aParameters != null && aParameters.length > 0) {
            this.dropPoint = (Point)aParameters[0];
        }
    }

    @Override
    protected Rectangle render(Graphics2D aCanvas) {
        FontMetrics fm = aCanvas.getFontMetrics();
        int yPos = fm.getLeading() + fm.getAscent();
        int labelWidth = 0;
        String label = this.getLabel();
        if (!label.isEmpty()) {
            labelWidth = fm.stringWidth(label);
            aCanvas.drawString(label, Math.max(2, 100 - labelWidth), yPos);
        }
        aCanvas.setStroke(INDICATOR_STROKE);
        aCanvas.drawLine(0, 0, 100, 0);
        return new Rectangle(-2, -2, Math.max(labelWidth, 100) + 4, yPos + 4);
    }

    private String getLabel() {
        ElementGroup channelGroupFor;
        SignalElement dropElement;
        String result = this.signalElement.getLabel();
        if (result == null) {
            result = "";
        }
        if (this.dropPoint != null && this.model.acceptDrop(this.signalElement, dropElement = this.model.findSignalElement(this.dropPoint)) && (channelGroupFor = dropElement.getGroup()) != null) {
            result = result.concat("  ").concat(channelGroupFor.getName());
        }
        return result.trim();
    }
}

