/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import nl.lxtreme.ols.api.data.Cursor;
import nl.lxtreme.ols.api.data.DataSet;
import nl.lxtreme.ols.api.data.project.Project;
import nl.lxtreme.ols.client.action.SmartJumpAction;
import nl.lxtreme.ols.client.actionmanager.IActionManager;
import nl.lxtreme.ols.client.actionmanager.IManagedAction;
import nl.lxtreme.ols.client.signaldisplay.ICursorChangeListener;
import nl.lxtreme.ols.client.signaldisplay.IDataModelChangeListener;
import nl.lxtreme.ols.client.signaldisplay.IMeasurementListener;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramComponent;
import nl.lxtreme.ols.client.signaldisplay.ZoomController;
import nl.lxtreme.ols.client.signaldisplay.dnd.DragAndDropTargetController;
import nl.lxtreme.ols.client.signaldisplay.model.SignalDiagramModel;
import nl.lxtreme.ols.client.signaldisplay.signalelement.ISignalElementChangeListener;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElement;
import nl.lxtreme.ols.client.signaldisplay.util.SmartJumpHelper;
import nl.lxtreme.ols.client.signaldisplay.view.ChannelLabelsView;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;

public final class SignalDiagramController
implements ZoomController.ZoomListener,
PropertyChangeListener {
    private final DragAndDropTargetController dndTargetController;
    private final IActionManager actionManager;
    private SignalDiagramModel signalDiagramModel;
    private SignalDiagramComponent signalDiagram;

    public SignalDiagramController(IActionManager aActionManager) {
        this.actionManager = aActionManager;
        this.dndTargetController = new DragAndDropTargetController(this);
    }

    public void addChannelChangeListener(ISignalElementChangeListener aListener) {
        this.getSignalDiagramModel().getSignalElementManager().addChannelChangeListener(aListener);
    }

    public void addCursorChangeListener(ICursorChangeListener aListener) {
        this.getSignalDiagramModel().addCursorChangeListener(aListener);
    }

    public void addDataModelChangeListener(IDataModelChangeListener aListener) {
        this.getSignalDiagramModel().addDataModelChangeListener(aListener);
    }

    public void addMeasurementListener(IMeasurementListener aListener) {
        this.getSignalDiagramModel().addMeasurementListener(aListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener aListener) {
        this.getSignalDiagramModel().addPropertyChangeListener(aListener);
    }

    public final IActionManager getActionManager() {
        return this.actionManager;
    }

    public Cursor[] getDefinedCursors() {
        return this.getSignalDiagramModel().getDefinedCursors();
    }

    public final DragAndDropTargetController getDndTargetController() {
        return this.dndTargetController;
    }

    public final SignalDiagramComponent getSignalDiagram() {
        return this.signalDiagram;
    }

    public final SignalDiagramModel getSignalDiagramModel() {
        return this.signalDiagramModel;
    }

    public SignalElement.SignalElementType getSignalHoverType(Point aPoint) {
        SignalElement element = this.getSignalDiagramModel().findSignalElement(aPoint);
        return element != null ? element.getType() : null;
    }

    public ZoomController getZoomController() {
        return this.signalDiagramModel.getZoomController();
    }

    public void initialize() {
        SignalDiagramModel model = new SignalDiagramModel(this);
        this.setSignalDiagramModel(model);
        model.getZoomController().addZoomListener(this);
        SignalDiagramComponent diagram = new SignalDiagramComponent(this);
        this.setSignalDiagram(diagram);
    }

    public boolean isCursorDefined(int aCursorIdx) {
        return this.getSignalDiagramModel().isCursorDefined(aCursorIdx);
    }

    public boolean isCursorMode() {
        return this.getSignalDiagramModel().isCursorMode();
    }

    public void moveCursor(int aCursorIdx, Point aPoint) {
        long newCursorTimestamp = this.locationToTimestamp(aPoint);
        this.getSignalDiagramModel().setCursor(aCursorIdx, newCursorTimestamp);
    }

    @Override
    public void notifyZoomChange(final ZoomController.ZoomEvent aEvent) {
        final boolean dataAvailable = this.getSignalDiagramModel().hasData();
        SwingComponentUtils.invokeOnEDT((Runnable)new Runnable(){

            @Override
            public void run() {
                IManagedAction zoomInAction = SignalDiagramController.this.getActionManager().getAction("ZoomIn");
                zoomInAction.setEnabled(dataAvailable && aEvent.canZoomIn());
                IManagedAction zoomOutAction = SignalDiagramController.this.getActionManager().getAction("ZoomOut");
                zoomOutAction.setEnabled(dataAvailable && aEvent.canZoomOut());
                IManagedAction zoomAllAction = SignalDiagramController.this.getActionManager().getAction("ZoomFit");
                zoomAllAction.setEnabled(dataAvailable && !aEvent.isZoomAll());
                IManagedAction zoomOriginalAction = SignalDiagramController.this.getActionManager().getAction("ZoomDefault");
                zoomOriginalAction.setEnabled(dataAvailable && !aEvent.isZoomOriginal());
                SignalDiagramComponent diagram = SignalDiagramController.this.getSignalDiagram();
                diagram.calculateDimensions();
                diagram.revalidateAll();
                diagram.repaintAll();
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent aEvent) {
        String name = aEvent.getPropertyName();
        if ("project".equals(name)) {
            Project project = (Project)aEvent.getNewValue();
            this.setDataModel(project.getDataSet());
        } else if ("capturedData".equals(name)) {
            DataSet dataSet = (DataSet)aEvent.getNewValue();
            this.setDataModel(dataSet);
            this.getZoomController().restoreZoomLevel();
        }
    }

    public void recalculateDimensions() {
        this.signalDiagram.calculateDimensions();
        this.signalDiagram.revalidateAll();
        this.signalDiagram.repaintAll();
    }

    public void removeChannelChangeListener(ISignalElementChangeListener aListener) {
        this.getSignalDiagramModel().getSignalElementManager().removeChannelChangeListener(aListener);
    }

    public void removeCursor(int aCursorIdx) {
        this.getSignalDiagramModel().removeCursor(aCursorIdx);
    }

    public void removeCursorChangeListener(ICursorChangeListener aListener) {
        this.getSignalDiagramModel().removeCursorChangeListener(aListener);
    }

    public void removeDataModelChangeListener(IDataModelChangeListener aListener) {
        this.getSignalDiagramModel().removeDataModelChangeListener(aListener);
    }

    public void removeMeasurementListener(IMeasurementListener aListener) {
        this.getSignalDiagramModel().removeMeasurementListener(aListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener aListener) {
        this.getSignalDiagramModel().removePropertyChangeListener(aListener);
    }

    public void scrollToTimestamp(long aTimestamp) {
        this.getSignalDiagram().scrollToTimestamp(aTimestamp);
    }

    public void setCursorMode(boolean aVisible) {
        this.getSignalDiagramModel().setCursorMode(aVisible);
    }

    public void setDataModel(DataSet aDataSet) {
        this.getSignalDiagramModel().setDataModel(aDataSet);
        this.recalculateDimensions();
    }

    public void setDefaultSettings() {
        this.setSnapModeEnabled(UIManager.getBoolean("ols.snap.cursors.default.boolean"));
    }

    public void setMeasurementMode(boolean aEnabled) {
        this.getSignalDiagramModel().setMeasurementMode(aEnabled);
    }

    public void setSelectedChannel(Point aPosition) {
        SignalDiagramModel model = this.getSignalDiagramModel();
        SignalElement signalElement = model.findSignalElement(aPosition);
        int oldIndex = model.getSelectedChannelIndex();
        int newIndex = -1;
        if (signalElement != null && signalElement.isDigitalSignal()) {
            newIndex = signalElement.getChannel().getIndex();
        }
        if (oldIndex != newIndex) {
            model.setSelectedChannelIndex(newIndex);
            ChannelLabelsView channelLabelsView = this.getChannelLabelsView();
            if (channelLabelsView != null) {
                SignalElement currentElement;
                int width = channelLabelsView.getWidth();
                if (signalElement != null) {
                    Rectangle rect1 = new Rectangle(0, signalElement.getYposition(), width, signalElement.getHeight());
                    channelLabelsView.repaint(rect1);
                }
                if ((currentElement = model.getSignalElementManager().getChannelByIndex(oldIndex)) != null) {
                    Rectangle rect2 = new Rectangle(0, currentElement.getYposition(), width, currentElement.getHeight());
                    channelLabelsView.repaint(rect2);
                }
            }
        }
    }

    public void setSnapModeEnabled(boolean aSnapMode) {
        this.getSignalDiagramModel().setSnapCursorMode(aSnapMode);
    }

    public void smartJump(int aChannelIndex, SmartJumpAction.JumpType aType, SmartJumpAction.JumpDirection aDirection) {
        SmartJumpHelper jumpHelper = new SmartJumpHelper(this, aDirection, aType);
        long timestamp = jumpHelper.getSmartJumpPosition(aChannelIndex);
        if (timestamp >= 0L) {
            this.scrollToTimestamp(timestamp);
        }
    }

    final void setSignalDiagram(SignalDiagramComponent aComponent) {
        this.signalDiagram = aComponent;
    }

    final void setSignalDiagramModel(SignalDiagramModel aSignalDiagramModel) {
        this.signalDiagramModel = aSignalDiagramModel;
    }

    private ChannelLabelsView getChannelLabelsView() {
        JScrollPane scrollPane = (JScrollPane)SwingComponentUtils.getAncestorOfClass(JScrollPane.class, (Component)this.getSignalDiagram());
        if (scrollPane != null) {
            return (ChannelLabelsView)scrollPane.getRowHeader().getView();
        }
        return null;
    }

    private long locationToTimestamp(Point aPoint) {
        return this.signalDiagram.getModel().locationToTimestamp(aPoint);
    }
}

