/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Deque;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import nl.lxtreme.ols.api.util.UnitOfTime;
import nl.lxtreme.ols.client.Activator;
import nl.lxtreme.ols.client.action.SmartJumpAction;
import nl.lxtreme.ols.client.actionmanager.IActionManager;
import nl.lxtreme.ols.client.actionmanager.IManagedAction;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;
import nl.lxtreme.ols.client.signaldisplay.ZoomController;
import nl.lxtreme.ols.client.signaldisplay.model.SignalDiagramModel;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElement;
import nl.lxtreme.ols.client.signaldisplay.util.GhostGlassPane;
import nl.lxtreme.ols.client.signaldisplay.view.ChannelLabelsView;
import nl.lxtreme.ols.client.signaldisplay.view.CornerView;
import nl.lxtreme.ols.client.signaldisplay.view.SignalView;
import nl.lxtreme.ols.client.signaldisplay.view.TimeLineView;
import nl.lxtreme.ols.util.AccumulatingRunnable;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;

public class SignalDiagramComponent
extends JPanel
implements Scrollable {
    static final Cursor CURSOR_WAIT = Cursor.getPredefinedCursor(3);
    static final Cursor CURSOR_HOVER = Cursor.getPredefinedCursor(1);
    static final Cursor CURSOR_MOVE_CURSOR = Cursor.getPredefinedCursor(12);
    static final Cursor CURSOR_MOVE_TIMESTAMP = Cursor.getPredefinedCursor(11);
    private static final long serialVersionUID = 1L;
    private final SignalDiagramController controller;
    private final SignalView signalView;
    private final ComponentEventHandler componentHandler;

    SignalDiagramComponent(SignalDiagramController aController) {
        super(new BorderLayout());
        this.controller = aController;
        this.signalView = SignalView.create(this.controller);
        this.componentHandler = new ComponentEventHandler(this.controller);
        this.add((Component)this.signalView, "Center");
        this.setOpaque(false);
        this.setAutoscrolls(true);
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        try {
            GhostGlassPane glassPane = new GhostGlassPane(this.controller);
            JRootPane rootPane = SwingUtilities.getRootPane(this);
            rootPane.setGlassPane(glassPane);
            this.configureEnclosingScrollPane();
            this.registerKeyBindings();
            this.revalidate();
        }
        finally {
            super.addNotify();
        }
    }

    public final SignalDiagramModel getModel() {
        return this.controller.getSignalDiagramModel();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle aVisibleRect, int aOrientation, int aDirection) {
        int inc = aOrientation == 1 ? this.getModel().getVerticalBlockIncrement(this.getSize(), aVisibleRect, aDirection) : this.getModel().getHorizontalBlockIncrement(aVisibleRect, aDirection);
        return inc;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle aVisibleRect, int aOrientation, int aDirection) {
        return this.getScrollableBlockIncrement(aVisibleRect, aOrientation, aDirection);
    }

    public final SignalView getSignalView() {
        return this.signalView;
    }

    public final Rectangle getVisibleViewSize() {
        SignalView component = this.getSignalView();
        JScrollPane scrollPane = (JScrollPane)SwingComponentUtils.getAncestorOfClass(JScrollPane.class, (Component)component);
        Rectangle rect = scrollPane != null ? scrollPane.getViewport().getBounds() : this.getVisibleRect();
        return rect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics aGraphics) {
        if (Activator.isDebugMode()) {
            long startTime = System.nanoTime();
            try {
                super.paint(aGraphics);
            }
            finally {
                long endTime = System.nanoTime();
                long renderTime = endTime - startTime;
                System.out.println("Rendering time = " + UnitOfTime.format((double)((double)renderTime / 1.0E9)));
            }
        } else {
            super.paint(aGraphics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        try {
            this.unconfigureEnclosingScrollPane();
        }
        finally {
            super.removeNotify();
        }
    }

    public void repaintSignalElement(SignalElement aSignalElement) {
        Rectangle rect = this.getVisibleRect();
        rect.y = aSignalElement.getYposition();
        rect.height = aSignalElement.getHeight();
        this.repaint(rect);
    }

    public void scrollToTimestamp(long aTimestamp) {
        SignalView signalView = this.getSignalView();
        Rectangle visibleRect = signalView.getVisibleRect();
        Rectangle rect = new Rectangle();
        rect.width = visibleRect.width;
        rect.height = visibleRect.height;
        rect.x = (int)(this.getModel().getZoomFactor() * (double)aTimestamp - rect.getCenterX());
        rect.y = visibleRect.y;
        signalView.scrollRectToVisible(rect);
    }

    final void calculateDimensions() {
        SignalView view = this.getSignalView();
        SignalDiagramModel model = this.getModel();
        JScrollPane scrollPane = (JScrollPane)SwingComponentUtils.getAncestorOfClass(JScrollPane.class, (Component)view);
        if (scrollPane != null) {
            Rectangle viewPortSize = scrollPane.getViewport().getVisibleRect();
            TimeLineView timeline = (TimeLineView)scrollPane.getColumnHeader().getView();
            ChannelLabelsView channelLabels = (ChannelLabelsView)scrollPane.getRowHeader().getView();
            int clWidth = channelLabels.getPreferredWidth();
            int tlHeight = timeline.getTimeLineHeight();
            int newWidth = Math.max(viewPortSize.width, model.getAbsoluteScreenWidth());
            int newHeight = Math.max(viewPortSize.height, model.getAbsoluteScreenHeight());
            timeline.setPreferredSize(new Dimension(newWidth, tlHeight));
            channelLabels.setPreferredSize(new Dimension(clWidth, newHeight));
            view.setPreferredSize(new Dimension(newWidth, newHeight));
        } else {
            Dimension frameSize = this.getRootPane().getSize();
            Rectangle viewSize = view.getVisibleRect();
            int minWidth = Math.max(viewSize.width, frameSize.width);
            int newWidth = Math.max(minWidth, model.getAbsoluteScreenWidth());
            int newHeight = Math.max(viewSize.height, model.getAbsoluteScreenHeight());
            view.setPreferredSize(new Dimension(newWidth, newHeight));
        }
    }

    final boolean hasData() {
        return this.getModel().hasData();
    }

    final void repaintAll() {
        this.signalView.repaint(50L);
        JScrollPane scrollPane = (JScrollPane)SwingComponentUtils.getAncestorOfClass(JScrollPane.class, (Component)this);
        if (scrollPane != null) {
            TimeLineView timeline = (TimeLineView)scrollPane.getColumnHeader().getView();
            timeline.repaint(50L);
            ChannelLabelsView channelLabels = (ChannelLabelsView)scrollPane.getRowHeader().getView();
            channelLabels.repaint(50L);
        }
    }

    final void revalidateAll() {
        this.revalidate();
        JScrollPane scrollPane = (JScrollPane)SwingComponentUtils.getAncestorOfClass(JScrollPane.class, (Component)this);
        if (scrollPane != null) {
            TimeLineView timeline = (TimeLineView)scrollPane.getColumnHeader().getView();
            timeline.revalidate();
            ChannelLabelsView channelLabels = (ChannelLabelsView)scrollPane.getRowHeader().getView();
            channelLabels.revalidate();
        }
    }

    private void configureEnclosingScrollPane() {
        JScrollPane scrollPane = (JScrollPane)SwingComponentUtils.getAncestorOfClass(JScrollPane.class, (Component)this);
        if (scrollPane != null) {
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            TimeLineView timelineView = TimeLineView.create(this.controller);
            scrollPane.setColumnHeaderView(timelineView);
            ChannelLabelsView channelLabelsView = ChannelLabelsView.create(this.controller);
            scrollPane.setRowHeaderView(channelLabelsView);
            scrollPane.setCorner("UPPER_LEADING_CORNER", new CornerView(this.controller));
            scrollPane.addComponentListener(this.componentHandler);
        }
    }

    private void registerKeyBindings() {
        int[] smartJumpRightKeys;
        int[] smartJumpLeftKeys;
        IActionManager actionManager = this.controller.getActionManager();
        IManagedAction zoomInAction = actionManager.getAction("ZoomIn");
        IManagedAction zoomOutAction = actionManager.getAction("ZoomOut");
        IManagedAction zoomAllAction = actionManager.getAction("ZoomFit");
        IManagedAction zoomOriginalAction = actionManager.getAction("ZoomDefault");
        SwingComponentUtils.registerKeyBinding((JComponent)this, (char)'+', (Action)zoomInAction);
        SwingComponentUtils.registerKeyBinding((JComponent)this, (char)'=', (Action)zoomInAction);
        SwingComponentUtils.registerKeyBinding((JComponent)this, (char)'-', (Action)zoomOutAction);
        SwingComponentUtils.registerKeyBinding((JComponent)this, (char)'_', (Action)zoomOutAction);
        SwingComponentUtils.registerKeyBinding((JComponent)this, (char)'[', (Action)zoomAllAction);
        SwingComponentUtils.registerKeyBinding((JComponent)this, (char)']', (Action)zoomOriginalAction);
        int[] modifiers = new int[]{64, 512, 128, 256};
        IManagedAction smartJumpLeftAction = actionManager.getAction(SmartJumpAction.getJumpLeftID());
        for (int key : smartJumpLeftKeys = new int[]{37, 226}) {
            for (int modifier : modifiers) {
                SwingComponentUtils.registerKeyBinding((JComponent)this, (KeyStroke)KeyStroke.getKeyStroke(key, modifier), (Action)smartJumpLeftAction);
            }
        }
        IManagedAction smartJumpRightAction = actionManager.getAction(SmartJumpAction.getJumpRightID());
        for (int key : smartJumpRightKeys = new int[]{39, 227}) {
            for (int modifier : modifiers) {
                SwingComponentUtils.registerKeyBinding((JComponent)this, (KeyStroke)KeyStroke.getKeyStroke(key, modifier), (Action)smartJumpRightAction);
            }
        }
    }

    private void unconfigureEnclosingScrollPane() {
        JScrollPane scrollPane = (JScrollPane)SwingComponentUtils.getAncestorOfClass(JScrollPane.class, (Component)this);
        if (scrollPane != null) {
            scrollPane.removeComponentListener(this.componentHandler);
            scrollPane.setColumnHeaderView(null);
            scrollPane.setRowHeaderView(null);
            scrollPane.setCorner("UPPER_LEADING_CORNER", null);
        }
    }

    static final class ComponentEventHandler
    extends ComponentAdapter {
        private final SignalDiagramController controller;
        private final AccumulatingRunnable<ComponentEvent> repaintQueue;

        public ComponentEventHandler(SignalDiagramController aController) {
            this.controller = aController;
            this.repaintQueue = new AccumulatingRunnable<ComponentEvent>(){

                protected void run(Deque<ComponentEvent> aArguments) {
                    ComponentEventHandler.this.scheduleRedraw(aArguments.getLast());
                }
            };
        }

        @Override
        public void componentResized(ComponentEvent aEvent) {
            this.repaintQueue.add((Object[])new ComponentEvent[]{aEvent});
        }

        @Override
        public void componentShown(ComponentEvent aEvent) {
            this.repaintQueue.add((Object[])new ComponentEvent[]{aEvent});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void scheduleRedraw(ComponentEvent aEvent) {
            JRootPane component = SwingUtilities.getRootPane(aEvent.getComponent());
            component.setCursor(CURSOR_WAIT);
            try {
                ZoomController zoomCtrl = this.controller.getZoomController();
                zoomCtrl.restoreZoomLevel();
            }
            finally {
                component.setCursor(null);
            }
        }
    }
}

