/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.action;

import java.awt.event.ActionEvent;
import nl.lxtreme.ols.client.ClientController;
import nl.lxtreme.ols.client.action.BaseAction;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;
import nl.lxtreme.ols.client.signaldisplay.model.SignalDiagramModel;

public class SmartJumpAction
extends BaseAction {
    private static final long serialVersionUID = 1L;
    private final JumpDirection direction;

    public SmartJumpAction(JumpDirection aDirection, ClientController aController) {
        super(SmartJumpAction.getID(aDirection), aController, SmartJumpAction.getTitle(aDirection), SmartJumpAction.getDescription(aDirection));
        this.direction = aDirection;
    }

    public static String getJumpLeftID() {
        return SmartJumpAction.getID(JumpDirection.LEFT);
    }

    public static String getJumpRightID() {
        return SmartJumpAction.getID(JumpDirection.RIGHT);
    }

    private static String getDescription(JumpDirection aDirection) {
        return String.format("<html>Jumps to the %1$s event. Use<br/>SHIFT to jump to %1$s cursor;<br/>CTRL to jump to %1$s edge, and<br/>ALT to jump to %1$s annotation.</html>", aDirection == JumpDirection.LEFT ? "previous" : "next");
    }

    private static String getID(JumpDirection aDirection) {
        return String.format("SmartJump%s", aDirection.name());
    }

    private static String getTitle(JumpDirection aDirection) {
        return String.format("Smart jump %s", aDirection.name().toLowerCase());
    }

    @Override
    public void actionPerformed(ActionEvent aEvent) {
        JumpType type = null;
        if ((aEvent.getModifiers() & 1) != 0) {
            type = JumpType.CURSOR;
        } else if ((aEvent.getModifiers() & 2) != 0) {
            type = JumpType.SIGNAL_EDGE;
        } else if ((aEvent.getModifiers() & 8) != 0) {
            type = JumpType.ANNOTATION;
        }
        if (type != null) {
            SignalDiagramController controller = this.getSignalDiagramController();
            controller.smartJump(this.getSignalDiagramModel().getSelectedChannelIndex(), type, this.direction);
        }
    }

    private SignalDiagramController getSignalDiagramController() {
        return this.getController().getSignalDiagramController();
    }

    private SignalDiagramModel getSignalDiagramModel() {
        return this.getSignalDiagramController().getSignalDiagramModel();
    }

    public static enum JumpType {
        CURSOR,
        SIGNAL_EDGE,
        ANNOTATION;

    }

    public static enum JumpDirection {
        LEFT,
        RIGHT;


        public boolean isLeft() {
            return this == LEFT;
        }

        public boolean isRight() {
            return this == RIGHT;
        }
    }
}

