/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.laf;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import nl.lxtreme.ols.client.signaldisplay.model.ChannelLabelsViewModel;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElement;
import nl.lxtreme.ols.client.signaldisplay.view.ChannelLabelsView;
import nl.lxtreme.ols.util.ColorUtils;

public class ChannelLabelsUI
extends ComponentUI {
    private static RenderingHints createRenderingHints() {
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        return hints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics aGraphics, JComponent aComponent) {
        ChannelLabelsView view = (ChannelLabelsView)aComponent;
        ChannelLabelsViewModel model = view.getModel();
        if (!model.hasData()) {
            return;
        }
        Graphics2D canvas = (Graphics2D)aGraphics.create();
        try {
            Rectangle clip = canvas.getClipBounds();
            SignalElement[] signalElements = model.getSignalElements(clip.y, clip.height);
            if (signalElements.length == 0) {
                return;
            }
            canvas.setRenderingHints(ChannelLabelsUI.createRenderingHints());
            canvas.setBackground(model.getBackgroundColor());
            canvas.clearRect(clip.x, clip.y, clip.width, clip.height);
            int compWidth = view.getWidth() - model.getGutterWidth();
            int spacingY = model.getSignalElementSpacing();
            canvas.translate(0, signalElements[0].getYposition());
            for (SignalElement signalElement : signalElements) {
                if (!signalElement.isSignalGroup()) {
                    this.paintBackground(canvas, model, signalElement, compWidth);
                    this.paintLabel(canvas, model, signalElement, compWidth);
                }
                canvas.translate(0, signalElement.getHeight() + spacingY);
            }
        }
        finally {
            canvas.dispose();
            canvas = null;
        }
    }

    private void drawLabel(Graphics2D aCanvas, ChannelLabelsViewModel aModel, String aText, Color aColor, int aXpos, int aYpos) {
        if (aModel.isDrawTextShadow()) {
            aCanvas.setColor(aModel.getTextShadowColor());
            aCanvas.drawString(aText, aXpos + 2, aYpos + 2);
        }
        aCanvas.setColor(aColor);
        aCanvas.drawString(aText, aXpos, aYpos);
    }

    private boolean isSelectedElement(SignalElement aElement, ChannelLabelsViewModel aModel) {
        if (!aElement.isDigitalSignal()) {
            return false;
        }
        return aModel.getSelectedChannelIndex() == aElement.getChannel().getIndex();
    }

    private void paintBackground(Graphics2D aCanvas, ChannelLabelsViewModel aModel, SignalElement aElement, int aWidth) {
        int arcWidth = aModel.getArcWidth();
        int x = -arcWidth;
        boolean y = false;
        int width = aWidth + arcWidth;
        int height = aElement.getHeight();
        Color color1 = aModel.getLabelGradientColor1();
        Color color2 = aModel.getLabelGradientColor2();
        if (this.isSelectedElement(aElement, aModel)) {
            color2 = ColorUtils.getHighlightColor((Color)color2, (float)2.0f);
        }
        GradientPaint paint = new GradientPaint(x, -5.0f, color2, x, height + 7, color1);
        Paint oldPaint = aCanvas.getPaint();
        aCanvas.setPaint(paint);
        aCanvas.fillRoundRect(x, 0, width, height, arcWidth, arcWidth);
        aCanvas.setPaint(oldPaint);
        aCanvas.setColor(aElement.getColor());
        aCanvas.drawRoundRect(x, 0, width, height, arcWidth, arcWidth);
    }

    private void paintLabel(Graphics2D aCanvas, ChannelLabelsViewModel aModel, SignalElement aElement, int aWidth) {
        String label = aElement.getLabel();
        int aHeight = aElement.getHeight();
        String index = "";
        if (aElement.isDigitalSignal() && aModel.isShowChannelIndex()) {
            index = Integer.toString(aElement.getChannel().getIndex());
        }
        boolean labelDefined = !"".equals(label.trim());
        boolean indexDefined = !"".equals(index.trim());
        Font labelFont = aModel.getLabelFont();
        FontMetrics labelFm = aCanvas.getFontMetrics(labelFont);
        Font indexFont = aModel.getIndexFont();
        FontMetrics indexFm = aCanvas.getFontMetrics(indexFont);
        int padding = aModel.getHorizontalPadding();
        Rectangle2D labelBounds = labelFm.getStringBounds(label, aCanvas);
        Rectangle2D indexBounds = indexFm.getStringBounds(index, aCanvas);
        double middle = (double)aHeight / 2.0;
        if (labelDefined) {
            int labelXpos = (int)((double)aWidth - labelBounds.getWidth() - (double)padding);
            int labelYpos = !indexDefined ? (int)(middle - labelBounds.getCenterY()) : (int)(middle - (double)labelFm.getDescent());
            Color labelColor = aModel.getLabelForegroundColor();
            if (this.isSelectedElement(aElement, aModel)) {
                labelColor = ColorUtils.getHighlightColor((Color)labelColor, (float)2.0f);
            }
            aCanvas.setFont(labelFont);
            this.drawLabel(aCanvas, aModel, label, labelColor, labelXpos, labelYpos);
        }
        if (indexDefined) {
            int indexXpos = (int)((double)aWidth - indexBounds.getWidth() - (double)padding);
            int indexYpos = !labelDefined ? (int)Math.round(middle + indexBounds.getCenterY()) : (int)Math.round(middle + (double)indexFm.getAscent());
            aCanvas.setFont(indexFont);
            this.drawLabel(aCanvas, aModel, index, aModel.getIndexForegroundColor(), indexXpos, indexYpos);
        }
    }
}

