/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.action;

import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;

public class SetCursorAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    public static final String KEY = "SetCursorAction";
    private final SignalDiagramController controller;
    private final int cursorIdx;

    public SetCursorAction(SignalDiagramController aController, int aCursorIdx) {
        super("Set cursor " + (aCursorIdx + 1));
        this.controller = aController;
        this.cursorIdx = aCursorIdx;
        int keyStroke = 48 + (aCursorIdx + 1) % 10;
        this.putValue("AcceleratorKey", SwingComponentUtils.createKeyMask((int)keyStroke, (int[])new int[0]));
        this.putValue("SwingSelectedKey", this.controller.isCursorDefined(aCursorIdx));
    }

    private static Point getContextMenuLocation(JMenuItem aMenuItem) {
        JComponent container = (JComponent)aMenuItem.getParent();
        Point location = (Point)container.getClientProperty(KEY);
        if (location == null) {
            return new Point(0, 0);
        }
        return location;
    }

    @Override
    public void actionPerformed(ActionEvent aEvent) {
        JMenuItem menuitem = (JMenuItem)aEvent.getSource();
        if (!this.controller.isCursorMode()) {
            this.controller.setCursorMode(true);
        }
        Point location = SetCursorAction.getContextMenuLocation(menuitem);
        this.controller.moveCursor(this.cursorIdx, location);
    }
}

