/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import nl.lxtreme.ols.client.Activator;
import nl.lxtreme.ols.util.swing.StandardActionFactory;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;
import nl.lxtreme.ols.util.swing.component.JErrorDialog;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class BundlesDialog
extends JDialog
implements StandardActionFactory.CloseAction.Closeable {
    private static final long serialVersionUID = 1L;
    private static final Color ALT_COLOR = new Color(204, 204, 204);
    private static final Color NEW_COLOR = ALT_COLOR.brighter();
    private final BundleContext bundleContext;
    private JTable table;

    public BundlesDialog(Window aOwner, BundleContext aBundleContext) {
        super(aOwner, "Running bundles", Dialog.ModalityType.APPLICATION_MODAL);
        this.setLocationRelativeTo(aOwner);
        this.bundleContext = aBundleContext;
        this.initDialog();
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    public boolean showDialog() {
        this.setVisible(true);
        return true;
    }

    final void startAllBundles(Bundle[] aBundles) {
        for (Bundle bundle : aBundles) {
            this.startBundle(bundle);
        }
        this.table.revalidate();
    }

    final void startBundle(Bundle aBundle) {
        try {
            if (aBundle.getState() == 4) {
                aBundle.start();
            }
        }
        catch (BundleException exception) {
            JErrorDialog.showDialog((Window)this.getOwner(), (String)"Starting bundle failed!", (Throwable)exception);
        }
    }

    final void stopAllBundles(Bundle[] aBundles) {
        for (Bundle bundle : aBundles) {
            this.stopBundle(bundle);
        }
        this.table.revalidate();
    }

    final void stopBundle(Bundle aBundle) {
        try {
            if (aBundle.getState() == 32) {
                aBundle.stop();
            }
        }
        catch (BundleException exception) {
            JErrorDialog.showDialog((Window)this.getOwner(), (String)"Stopping bundle failed!", (Throwable)exception);
        }
    }

    private JPanel createBundleViewPane() {
        final Bundle[] bundles = this.bundleContext.getBundles();
        this.table = new JTable(new TableModel(bundles)){
            private static final long serialVersionUID = 1L;

            @Override
            public Component prepareRenderer(TableCellRenderer aRenderer, int aRow, int aColumn) {
                Component result = super.prepareRenderer(aRenderer, aRow, aColumn);
                if (!result.getBackground().equals(this.getSelectionBackground())) {
                    result.setBackground(aRow % 2 != 0 ? ALT_COLOR : NEW_COLOR);
                }
                if (result instanceof JComponent) {
                    Object value = this.getModel().getValueAt(aRow, aColumn);
                    ((JComponent)result).setToolTipText(String.valueOf(value));
                }
                return result;
            }
        };
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(25);
        this.table.getColumnModel().getColumn(0).setMaxWidth(25);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(30);
        this.table.getColumnModel().getColumn(1).setMaxWidth(40);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(60);
        this.table.getColumnModel().getColumn(3).setMaxWidth(100);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(60);
        this.table.getColumnModel().getColumn(4).setMaxWidth(100);
        this.table.getSelectionModel().setSelectionMode(0);
        boolean visible = Activator.isDebugMode();
        JButton selectAll = new JButton("Select all");
        selectAll.setVisible(visible);
        selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                BundlesDialog.this.startAllBundles(bundles);
            }
        });
        JButton deselectAll = new JButton("Deselect all");
        deselectAll.setVisible(visible);
        deselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                BundlesDialog.this.stopAllBundles(bundles);
            }
        });
        JButton crashTest = new JButton("Crash test");
        crashTest.setVisible(visible);
        crashTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                Runnable thrower = new Runnable(){

                    @Override
                    public void run() {
                        throw new RuntimeException("Test exception; nothing to worry about...");
                    }
                };
                SwingUtilities.invokeLater(thrower);
            }
        });
        JPanel selectionPanel = new JPanel();
        selectionPanel.add(selectAll);
        selectionPanel.add(deselectAll);
        selectionPanel.add(crashTest);
        JPanel view = new JPanel();
        view.setLayout(new BorderLayout());
        view.add((Component)selectionPanel, "South");
        view.add((Component)new JScrollPane(this.table), "Center");
        return view;
    }

    private void initDialog() {
        JPanel editorsPane = this.createBundleViewPane();
        JButton cancel = StandardActionFactory.createCloseButton();
        JComponent buttonPane = SwingComponentUtils.createButtonPane((JButton[])new JButton[]{cancel});
        SwingComponentUtils.setupDialogContentPane((JDialog)this, (Component)editorsPane, (Component)buttonPane, (JButton)cancel);
    }

    final class TableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final Bundle[] bundles;

        public TableModel(Bundle[] aBundles) {
            this.bundles = aBundles;
        }

        @Override
        public Class<?> getColumnClass(int aColumnNr) {
            return this.getValueAt(0, aColumnNr).getClass();
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public String getColumnName(int aColumn) {
            switch (aColumn) {
                case 0: {
                    return "";
                }
                case 1: {
                    return "#";
                }
                case 2: {
                    return "Symbolic Name";
                }
                case 3: {
                    return "Version";
                }
                case 4: {
                    return "State";
                }
                case 5: {
                    return "Copyright";
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.bundles.length;
        }

        @Override
        public Object getValueAt(int aRowIndex, int aColumnIndex) {
            Bundle bundle = this.bundles[aRowIndex];
            switch (aColumnIndex) {
                case 0: {
                    return bundle.getState() == 32;
                }
                case 1: {
                    return bundle.getBundleId();
                }
                case 2: {
                    return bundle.getSymbolicName();
                }
                case 3: {
                    return bundle.getVersion();
                }
                case 4: {
                    switch (bundle.getState()) {
                        case 32: {
                            return "Active";
                        }
                        case 2: {
                            return "Installed";
                        }
                        case 4: {
                            return "Resolved";
                        }
                        case 1: {
                            return "Uninstalled";
                        }
                    }
                    return "<???>";
                }
                case 5: {
                    String copyright = (String)bundle.getHeaders().get("Bundle-Copyright");
                    return copyright == null ? "Unknown" : copyright;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int aRow, int aColumn) {
            if (aColumn == 0) {
                return Activator.isDebugMode();
            }
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int aRow, int aColumn) {
            Bundle selectedBundle = this.bundles[aRow];
            if (selectedBundle.getState() == 32) {
                BundlesDialog.this.stopBundle(selectedBundle);
            } else if (selectedBundle.getState() == 4) {
                BundlesDialog.this.startBundle(selectedBundle);
            }
            this.fireTableDataChanged();
        }
    }
}

