/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl.metatype;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.felix.dm.PropertyMetaData;
import org.apache.felix.dm.impl.Logger;
import org.apache.felix.dm.impl.metatype.ObjectClassDefinitionImpl;
import org.apache.felix.dm.impl.metatype.Resource;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.ObjectClassDefinition;

public class MetaTypeProviderImpl
implements MetaTypeProvider,
ManagedService,
ManagedServiceFactory {
    private ManagedService m_managedServiceDelegate;
    private ManagedServiceFactory m_managedServiceFactoryDelegate;
    private List m_propertiesMetaData = new ArrayList();
    private String m_description;
    private String m_heading;
    private String m_localization;
    private Map m_localesProperties = new HashMap();
    private Logger m_logger;
    private BundleContext m_bctx;
    private String m_pid;

    public MetaTypeProviderImpl(String pid, BundleContext ctx, Logger logger, ManagedService msDelegate, ManagedServiceFactory msfDelegate) {
        this.m_pid = pid;
        this.m_bctx = ctx;
        this.m_logger = logger;
        this.m_managedServiceDelegate = msDelegate;
        this.m_managedServiceFactoryDelegate = msfDelegate;
        this.m_localization = (String)this.m_bctx.getBundle().getHeaders().get("Bundle-Localization");
        if (this.m_localization == null) {
            this.m_localization = "OSGI-INF/l10n/bundle";
        }
    }

    public void add(PropertyMetaData property) {
        this.m_propertiesMetaData.add(property);
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setName(String heading) {
        this.m_heading = heading;
    }

    public void setLocalization(String path) {
        if (path.endsWith(".properties")) {
            throw new IllegalArgumentException("path must point to the base name of the propertie file, excluding local suffixes. For example: foo/bar/person is valid and matches the property file \"foo/bar/person_bundle_en_GB_welsh.properties\"");
        }
        this.m_localization = path.startsWith("/") ? path.substring(1) : path;
    }

    public String[] getLocales() {
        int lastSlash = this.m_localization.lastIndexOf("/");
        String path = lastSlash == -1 ? "/" : "/" + this.m_localization.substring(0, lastSlash - 1);
        String base = lastSlash == -1 ? this.m_localization : this.m_localization.substring(lastSlash + 1);
        Enumeration e = this.m_bctx.getBundle().findEntries(path, base + "*.properties", false);
        if (e == null) {
            return null;
        }
        TreeSet<String> set = new TreeSet<String>();
        while (e.hasMoreElements()) {
            URL url = (URL)e.nextElement();
            String name = url.getPath();
            int underscore = (name = name.substring(name.lastIndexOf("/") + 1)).indexOf("_");
            if (underscore != -1) {
                name = name.substring(underscore + 1, name.length() - ".properties".length());
            }
            if (name.length() <= 0) continue;
            set.add(name);
        }
        String[] locales = set.toArray(new String[set.size()]);
        return locales.length == 0 ? null : locales;
    }

    public ObjectClassDefinition getObjectClassDefinition(String id, String locale) {
        try {
            if (!id.equals(this.m_pid)) {
                this.m_logger.log(1, "id " + id + " does not match pid " + this.m_pid);
                return null;
            }
            Properties localeProperties = this.getLocaleProperties(locale);
            return new ObjectClassDefinitionImpl(this.m_pid, this.m_heading, this.m_description, this.m_propertiesMetaData, new Resource(localeProperties));
        }
        catch (Throwable t) {
            this.m_logger.log(1, "Unexpected exception while geting ObjectClassDefinition for " + id + " (locale=" + locale + ")", t);
            return null;
        }
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        this.m_managedServiceDelegate.updated(properties);
    }

    private synchronized Properties getLocaleProperties(String locale) throws IOException {
        Properties properties = (Properties)this.m_localesProperties.get(locale = locale == null ? Locale.getDefault().toString() : locale);
        if (properties == null) {
            properties = new Properties();
            URL url = this.m_bctx.getBundle().getEntry(this.m_localization + ".properties");
            if (url != null) {
                this.loadLocale(properties, url);
            }
            String path = this.m_localization;
            StringTokenizer tok = new StringTokenizer(locale, "_");
            while (tok.hasMoreTokens()) {
                path = path + "_" + tok.nextToken();
                url = this.m_bctx.getBundle().getEntry(path + ".properties");
                if (url == null) continue;
                properties = new Properties(properties);
                this.loadLocale(properties, url);
            }
            this.m_localesProperties.put(locale, properties);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLocale(Properties properties, URL url) throws IOException {
        InputStream in = null;
        try {
            in = url.openStream();
            properties.load(in);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public void deleted(String pid) {
        this.m_managedServiceFactoryDelegate.deleted(pid);
    }

    public String getName() {
        return this.m_pid;
    }

    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        this.m_managedServiceFactoryDelegate.updated(pid, properties);
    }
}

