// LISTING 3.22. Wstrzyknięcie i użycie komponentu SearchService

import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.bc.issue.search.SearchService;

// 1. Wstrzyknięcie komponentu SearchService.
def searchService = ComponentAccessor.getComponent(SearchService);

// 2. Pobranie obiektu typu interfejsowego ApplicationUser aktualnie zalogowanego użytkownika.
def user = ComponentAccessor.jiraAuthenticationContext.getLoggedInUser();

// 3. Zainicjowanie zmiennej z zapytaniem JQL w postaci String.
def jqlSearch = """(issuetype in (Story, Epic, Task, Sub-task) AND Resolution in (Done, Fixed) AND (issueFunction in linkedIssuesOf("project = PROJ") OR issueFunction in issuesInEpics("issueFunction in linkedIssuesOf('project = PROJ')")) AND (resolutiondate > -7d OR updated > -7d OR issueFunction in linkedIssuesOf("project = PROJ AND updated > -7d")))""";

// 4. Parsowanie zapytania JQL.
def parseResult = searchService.parseQuery(user, jqlSearch);

// 5. Wykonanie zapytania jako zdefiniowany użytkownik i zwrócenie wyników.
def searchResults = searchService.search(user, parseResult.getQuery(), PagerFilter.getUnlimitedFilter());

// 6. Pobranie wyników i przekształcenie ich w listę obiektów typu interfejsowego Issue.
def tasks = searchResults.getResults().collect {ComponentAccessor.getIssueManager().getIssueObject(it.id)};

// 7. Praca na utworzonej liście.
tasks.each {
    task ->
        /* do something*/
};