// LISTING 25.3. Wyświetlenie hierarchii ObjectBean, ObjectAttibuteBean, ObjectAttributeValueBean

import com.atlassian.jira.component.ComponentAccessor;

// 1. Pobranie zgłoszenia z uzupełnionymi wartościami custom fieldów.
def issue = ComponentAccessor.getIssueManager().getIssueObject("CM-1");

// 2. Pobranie obiektu typu interfejsowego CustomField.
def branchesField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10400L);

// 3. Pobranie wartości custom fieldów ze zgłoszenia.
def branchesFieldValue = issue.getCustomFieldValue(branchesField);

// 4. Wyświetlenie wyniku.

// 4.1. Lista obiektów ObjectBean z custom fieldu.
branchesFieldValue.each {
    objectBean ->
        
        // Typ loggera zależy od ustawień w sekcji Logging and profiling ustawień Jiry.
        log.info(objectBean.toString());

        // 4.2. Lista obiektów ObjectAtrributeBean.
        objectBean.getObjectAttributeBeans().each {
            objectAttributeBeans ->
                
                // Typ loggera zależy od ustawień w sekcji Logging and profiling ustawień Jiry.
                log.info("\t ${objectAttributeBeans.toString()}");

                // 4.3. Lista obiektów ObjectAttributeValueBean.
                objectAttributeBeans.getObjectAttributeValueBeans().each {
                    objectAttributeValueBean ->
                        log.info("\t\t ${objectAttributeValueBean.getTextValue()}")
                };
        };
};