// LISTING 22.9. Kopiowanie zawartości z innej strony

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseHandler;
import groovy.json.JsonSlurper;
import groovy.json.JsonBuilder;

// 1. Inicjalizacja ApplicationLink.
def ApplicationLink getPrimaryConfluenceLink() {
    def applicationLinkService = ComponentLocator.getComponent(ApplicationLinkService);
    final ApplicationLink confluenceApplicationLink = applicationLinkService.getPrimaryApplicationLink(ConfluenceApplicationType);
    return confluenceApplicationLink;
}

// 2. Inicjalizacja fabryczki do wysyłania żądań przez Confluence API.
def confluenceLink = getPrimaryConfluenceLink();
def authenticatedRequestFactory = confluenceLink.createImpersonatingAuthenticatedRequestFactory();

// 3. Pobranie zawartości strony w postaci kodu HTML-a do skopiowania.
// Identyfikator strony w Confluence to 65552.
// Rozszerzenie body.view powoduje załączenie w odpowiedzi węzła z kodem HTML-a strony.
String htmlBody;
authenticatedRequestFactory
    .createRequest(Request.MethodType.GET, "/rest/api/content/65552?expand=body.view")
    .addHeader("Content-Type", "application/json")
    .execute(new ResponseHandler<Response>() {
        @Override
            void handle(Response response) throws ResponseException {
                if (response.statusCode != HttpURLConnection.HTTP_OK) {
                    throw new Exception(response.getResponseBodyAsString());
                } else {
                    // 3.1. Wybranie z obiektu JSON węzła z kodem HTML-a strony.
                    htmlBody = new JsonSlurper().parseText(response.responseBodyAsString)["body"]["view"]["value"];
                }
            }
    });

// 4. Inicjalizacja mapy podstawowych parametrów do utworzenia strony.
def createPageRequestBody = [
    type: "page",
    title: "Cloned page",
    space: [
        key: "SMP2"
    ],
    body: [
        storage: [
            // 4.1. W zmiennej htmlBody znajduje się kod HTML-a ze strony źródłowej.
            value: htmlBody,
            representation: "storage"
        ]
    ]
];

// 5. Wykonanie operacji tworzenia strony w Confluence.
def newPageId;
authenticatedRequestFactory
    .createRequest(Request.MethodType.POST, "rest/api/content")
    .addHeader("Content-Type", "application/json")
    .setRequestBody(new JsonBuilder(createPageRequestBody).toString())
    .execute(new ResponseHandler<Response>() {
    
        @Override
        void handle(Response response) throws ResponseException {
            if (response.statusCode != HttpURLConnection.HTTP_OK) {
                throw new Exception(response.getResponseBodyAsString())
            } else {
                newPageId = new JsonSlurper().parseText(response.responseBodyAsString)["id"];
                log.info "Page ${newPageId} has been created.";
            }
        }
    });