// LISTING 15.4. Aktualizacja listy komponentów w zgłoszeniu

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.component.ComponentAccessor;

// 1. Pobranie obiektu typu interfejsowego ApplicationUser do wykonania zmiany w zgłoszeniu.
def adminUser = ComponentAccessor.getUserManager().getUserByName("admin");

// 2. Pobranie menedżerów.
def projectComponentManager = ComponentAccessor.getProjectComponentManager();
def issueManager = ComponentAccessor.getIssueManager();

// 3. Pobranie obiektu typu interfejsowego Issue ze zdefiniowanymi komponentami i zrzutowanie do MutableIssue.
// Zgłoszenie znajduje się w komponentach Moduł integracji z systemami zewnętrznymi i Moduł ksiąg rachunkowych.
def issue = issueManager.getIssueObject("SKX-4") as MutableIssue;

// 4. Pobranie obiektu typu interfejsowego ProjectComponent komponentu Moduł faktur o identyfikatorze 10000.
// Zgłoszenie zostanie dodane do poniższego komponentu.
def componentToAdd = projectComponentManager.getProjectComponent(10000);

// 5. (Opcja 1) Dodanie nowego komponentu do listy istniejących w zgłoszeniu.
def actualComponentList = issue.getComponents();
actualComponentList.add(componentToAdd);
issue.setComponent(actualComponentList);
issueManager.updateIssue(adminUser, issue, EventDispatchOption.ISSUE_UPDATED, false);

// 6. (Opcja 2) Nadpisanie listy komponentów jednym nowym komponentem.
Collection<ProjectComponent> newComponentList = new ArrayList<>();
newComponentList.add(componentToAdd);
issue.setComponent(newComponentList);
issueManager.updateIssue(adminUser, issue, EventDispatchOption.ISSUE_UPDATED, false);