// LISTING 12.11. Pobieranie daty i czasu z custom fieldu typu date picker i date time picker

import java.sql.Timestamp;
import com.atlassian.jira.component.ComponentAccessor;

// 1. Pobranie menedżerów.
def issueManager = ComponentAccessor.getIssueManager();
def customFieldManager = ComponentAccessor.getCustomFieldManager();

// 2. Pobranie przykładowego zgłoszenia według klucza.
def issue = issueManager.getIssueObject("OZP-1");

// 3. Pobranie obiektów typu interfejsowego CustomField.

// Date time picker.
def actionDateField = customFieldManager.getCustomFieldObject(10403L);

// Date picker.
def plannedResolutionDate = customFieldManager.getCustomFieldObject(10402L);

// 4. Pobranie wartości pól ze zgłoszenia.
def actionDateFieldValue = issue.getCustomFieldValue(actionDateField) as Timestamp;
def plannedResolutionDateValue = issue.getCustomFieldValue(plannedResolutionDate) as Timestamp;

// 5. Wyświetlenie daty w formacie z serwera.
def date1 = actionDateFieldValue.getDateString();
def date2 = plannedResolutionDateValue.getDateString();

// 6. Wyświetlenie daty w formacie lokalnym.
def date3 = actionDateFieldValue.toLocalDateTime().getDateString();
def date4 = plannedResolutionDateValue.toLocalDateTime().getDateString();

// 7. Wyświetlenie daty i czasu w formacie z serwera.
def dateTime1 = actionDateFieldValue.getDateTimeString();
def dateTime2 = plannedResolutionDateValue.getDateTimeString();

// 8. Wyświetlenie daty i czasu w formacie lokalnym.
def dateTime3 = actionDateFieldValue.toLocalDateTime().getDateTimeString();
def dateTime4 = plannedResolutionDateValue.toLocalDateTime().getDateTimeString();

// 9. Wyświetlenie czasu w formacie z serwera.
def time1 = actionDateFieldValue.getTimeString()
def time2 = plannedResolutionDateValue.getTimeString();

// 10. Wyświetlenie czasu w formacie lokalnym.
def time3 = actionDateFieldValue.toLocalDateTime().getTimeString();
def time4 = plannedResolutionDateValue.toLocalDateTime().getTimeString();

// 11. Wyświetlenie wyników.
// date1: 6/15/22 | date2: 6/23/22 | date3: 2022-06-15 | date4: 2022-06-23 |
// dateTime1: 6/15/22 10:34:00 PM | dateTime2: 6/23/22 12:00:00 AM |
// dateTime3: 2022-06-15T22:34:00 | dateTime4: 2022-06-23T00:00:00 |
// time1: 10:34:00 PM | time2: 12:00:00 AM | time3: 22:34:00 | time4: 00:00:00
return "date1: ${date1} | date2: ${date2} | date3: ${date3} | date4: ${date4} |dateTime1: ${dateTime1} | dateTime2: ${dateTime2} | dateTime3: ${dateTime3} |dateTime4: ${dateTime4} | time1: ${time1} | time2: ${time2} | time3: ${time3} |time4: ${time4}";