// LISTING 10.19. Klasa MyValidator z warunkiem umożliwiającym wykonanie przejścia w workflow

package pl.helion.jira.workflow;

import com.atlassian.jira.issue.Issue;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.Validator;
import com.opensymphony.workflow.InvalidInputException;
import java.util.Collection;
import java.util.Map;
/**
 * Klasa zawiera metodę validate(), w której ciele umieszcza się kod wyrzucający błąd,
 * jeżeli nie został spełniony warunek określony w ustawieniach walidatora.
 * W mapie args znajdują się zmienne załadowane w metodzie getDescriptorParams() z klasy MyValidatorFactory.
 */
public class MyValidator implements Validator {
    
    /**
     * 1. Metoda wykonująca skrypt walidatora przy próbie wykonania przejścia.
     * @param transientVars — tablica przechowująca dane przejścia.
     * @param args — parametry załadowane w MyValidatorFactory.
     * @param ps — property nie jest wykorzystywane.
     */
    public void validate(Map transientVars, Map args, PropertySet ps) throws InvalidInputException {

        // 2. Pobranie aktualnej wartości statusu zgłoszenia z ustawień walidatora.
        String subTaskStatus = (String)args.get("subTaskStatus");

        // 3. Pobranie obiektu typu interfejsowego Issue zgłoszenia, na którym jest wykonywane przejście.
        Issue issue = (Issue)transientVars.get("issue");
        
        // 4. Zbadanie, czy zgłoszenie ma sub-task o statusie innym niż określony w ustawieniach walidatora.
        Collection<Issue> subTasks = issue.getSubTaskObjects();
        boolean condition = false;
        if (subTasks.size()>0)
            condition = subTasks.stream().filter(
                    subTask ->
                            !subTask.getStatus().getName().equals(subTaskStatus)
            ).findAny().isPresent();

        // 5. Wyrzucenie błędu z komentarzem, jeżeli istnieją sub-taski o statusie innym niż w ustawieniach walidatora.
        if (condition && subTasks.size()>0)
            throw new InvalidInputException("All sub-tasks must be in the '" +
                    subTaskStatus + "' status.");
    }
}