// LISTING 3.23. Wstrzyknięcie i użycie komponentu UserService

import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.component.ComponentAccessor;

// 1. Wstrzyknięcie komponentu UserService.
def userService = ComponentAccessor.getComponent(UserService);

// 2. Pobranie obiektu typu interfejsowego ApplicationUser użytkownika do zmiany.
def userToChanger = ComponentAccessor.getUserManager().getUserByName("mkopernik");

// 3. Edycja istniejącego użytkownika.

// 3.1. Inicjalizacja buildera dla wybranego obiektu typu interfejsowego ApplicationUser i wykonanie zmian.
def applicationUserBuilder = userService.newUserBuilder(userToChanger);
applicationUserBuilder.displayName("Mikołaj Kopernik (astronom)");
applicationUserBuilder.emailAddress("info@info.com");
def modifiedUserData = applicationUserBuilder.build();

// 3.2. Wykonanie walidacji.
def updateUserValidationResult = userService.validateUpdateUser(modifiedUserData);

// 3.3. Wykonanie zmiany, jeżeli wyniki walidacji są pozytywne.
return updateUserValidationResult.isValid()?userService.updateUser(updateUserValidationResult):"Error";