// LISTING 3.20. Wstrzyknięcie i użycie komponentu IssueIndexingService

import com.atlassian.jira.util.ImportUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.index.IssueIndexingService;

// 1. Wstrzyknięcie komponentu IssueIndexingService.
def issueIndexingService = ComponentAccessor.getComponent(IssueIndexingService);

// 2. Pobranie obiektu typu interfejsowego Issue przykładowego zgłoszenia do reindeksacji.
def someIssue = ComponentAccessor.getIssueManager().getIssueObject("BP1-3");

// 3. Wykonanie reindeksacji.
def issueIndex = ComponentAccessor.getIssueManager().getIssueByCurrentKey(someIssue.getKey());
def wasIndexing = ImportUtils.isIndexIssues();
ImportUtils.setIndexIssues(true);
issueIndexingService.reIndex(issueIndex);
ImportUtils.setIndexIssues(wasIndexing);