// LISTING 3.19. Wstrzyknięcie i użycie komponentu IssueService

import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.component.ComponentAccessor;

// 1. Wstrzyknięcie komponentu IssueService.
def issueService = ComponentAccessor.getIssueService();

// 2. Przygotowanie parametrów nowego zgłoszenia.
IssueInputParameters inputParameters = issueService.newIssueInputParameters();
def user = ComponentAccessor.getUserManager().getUserByName("admin");

inputParameters
    .setProjectId(12345)
    .setIssueTypeId("12345")
    .setSummary("summary text")
    .setReporterId(user.getName())
    .setAssigneeId(user.getName())
    .setDescription("description test");

// 3. Wykonanie walidacji parametrów nowego zgłoszenia.
def createValidationResult = issueService.validateCreate(user, inputParameters);

// 4. Utworzenie nowego zgłoszenia.
def issueResult = issueService.create(user, createValidationResult);