// LISTING 3.15. Wstrzyknięcie i użycie komponentu ProjectRoleManager

import com.atlassian.jira.security.roles.ProjectRoleImpl;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.component.ComponentAccessor;

// 1. Wstrzyknięcie komponentu m.in. ProjectRoleManager.
def projectRoleManager = ComponentAccessor.getComponent(ProjectRoleManager);
def projectManager = ComponentAccessor.getProjectManager();

// 2. Pobranie obiektu roli o identyfikatorze 10100 (Developers z ustawień Jiry).
def projectRole = projectRoleManager.getProjectRole(10100);

// 3. Pobranie obiektów typu interfejsowego ApplicationUser użytkowników przypisanych do roli Developers w projekcie o identyfikatorze 10406.
def project = projectManager.getProjectObj(10406L);
def developers = projectRoleManager.getProjectRoleActors(projectRole, project).getUsers();

// 4. Utworzenie nowej roli w ustawieniach Jiry.
projectRoleManager.createRole(new ProjectRoleImpl("Analysts", "Sample description"));

// 5. Sprawdzenie, czy użytkownik jest dodany do konkretnej roli w projekcie.
def userToCheck = ComponentAccessor.getUserManager().getUserByName("jnowak");
def isUserInRole = projectRoleManager.isUserInProjectRole(userToCheck, projectRole, project);

// 6. Wyświetlenie wyników.
// projectRole: Developers | developers: mkopernik, jnowak | isUserInRole: true
return "projectRole: ${projectRole.getName()} | developers: ${String.join(", ", developers.collect() {actor -> actor.getUsername()})} | isUserInRole: ${isUserInRole}";