// LISTING 25.7. Aktualizacja custom fieldu typu Insight object/s danymi pobranymi zapytaniem IQL

import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.component.ComponentAccessor;
import com.onresolve.scriptrunner.runner.customisers.WithPlugin;
@WithPlugin("com.riadalabs.jira.plugins.insight")

// 1. Pobranie komponentu IQLFacade.
Class iqlFacadeClass = ComponentAccessor.getPluginAccessor().getClassLoader().loadClass("com.riadalabs.jira.plugins.insight.channel.external.api.facade.IQLFacade");
def iqlFacade = ComponentAccessor.getOSGiComponentInstanceOfType(iqlFacadeClass) as com.riadalabs.jira.plugins.insight.channel.external.api.facade.IQLFacade;

// 2. Pobranie zgłoszenia z uzupełnionymi wartościami custom fieldów i zrzutowanie do typu interfejsowego MutableIssue.
def issue = ComponentAccessor.getIssueManager().getIssueObject("CM-2") as MutableIssue;

// 3. Pobranie obiektu typu interfejsowego ApplicationUser użytkownika do wykonania aktualizacji zgłoszenia.
def adminUser = ComponentAccessor.getUserManager().getUserByName("admin");

// 4. Pobranie obiektu typu interfejsowego CustomField.
def allOperatorsField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10500L);

// 5. Pobranie danych do zmiany wartości custom fieldu za pomocą zapytania IQL.
// Identyfikator schematu obiektów My Company Database to 1.
// Można go odczytać z URL po wejściu do schematu, np. ../secure/ObjectSchema.jspa?id=1&typeId=1&objectId=19.
def objectsToAdd = iqlFacade.findObjectsByIQLAndSchema(1, "objectType = Employees and \"Related branch\" = \"Customer Care Center\"");

// 6. Aktualizacja wartości obiektu typu interfejsowego MutableIssue.
issue.setCustomFieldValue(allOperatorsField, objectsToAdd);

// 7. Wykonanie aktualizacji zgłoszenia.
ComponentAccessor.getIssueManager().updateIssue(adminUser, issue, EventDispatchOption.ISSUE_UPDATED, false);