// LISTING 22.2. Pobranie strony przez Confluence API 5

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseHandler;
import groovy.json.JsonSlurper;
import com.atlassian.renderer.wysiwyg.converter.DefaultWysiwygConverter;

// 1. Inicjalizacja ApplicationLink.
def ApplicationLink getPrimaryConfluenceLink() {
    def applicationLinkService = ComponentLocator.getComponent(ApplicationLinkService);
    final ApplicationLink confluenceApplicationLink = applicationLinkService.getPrimaryApplicationLink(ConfluenceApplicationType);
    return confluenceApplicationLink;
}

// 2. Inicjalizacja fabryczki do wysyłania żądań przez Confluence API.
def confluenceLink = getPrimaryConfluenceLink();
def authenticatedRequestFactory = confluenceLink.createImpersonatingAuthenticatedRequestFactory();

// 3. Pobranie zawartości strony w postaci kodu HTML-a.
// Identyfikator strony w Confluence to 65554.
// Rozszerzenie body.view powoduje załączenie w odpowiedzi węzła z kodem HTML-a strony.
String htmlBody;
authenticatedRequestFactory
    .createRequest(Request.MethodType.GET, "/rest/api/content/65554?expand=body.view")
    .addHeader("Content-Type", "application/json")
    .execute(new ResponseHandler<Response>() {

        @Override
        void handle(Response response) throws ResponseException {
            if (response.statusCode != HttpURLConnection.HTTP_OK) {
                throw new Exception(response.getResponseBodyAsString());
            } else {
                // 3.1. Wybranie z obiektu JSON węzła z kodem HTML-a strony.
                htmlBody = new JsonSlurper().parseText(response.responseBodyAsString)["body"]["view"]["value"];
            }
        }
});

// 4. Przekształcenie kodu HTML-a do zapisu WikiMarkup.
String markupBody = new DefaultWysiwygConverter().convertXHtmlToWikiMarkup(htmlBody);