// LISTING 19.6. Utworzenie zgłoszenia za pomocą Jira REST API

// 1. Token użytkownika.
def token = "OTUxODQxMjc3ODIwOs8GGxW31/mPWMI9gH0UqLp+OQRq";

// 2. URI endpointa Jira REST API.
def url = "http://172.16.117.141:8080/rest/api/2/issue/";

// 3. Zainicjowanie ciała zapytania.
def jsonBody = """
{
    "fields": {
        "project": {"key": "CM"},
        "issuetype": { "name": "Story"},
        "summary": "Example Summary",
        "description": "Example description",
        "assignee": {"name": "jkowalski"}
    }
}
""";

// 4. Otwarcie połączenia z endpointem.
def connection = url.toURL().openConnection() as HttpURLConnection;

// 5. Dodanie parametrów połączenia.
connection.setRequestMethod("POST");
connection.addRequestProperty("Authorization", "Bearer " + token);
connection.addRequestProperty("X-Atlassian-Token", "no-check");
connection.setDoOutput(true);
connection.addRequestProperty("Content-Type", "application/json");

// 6. Zapisanie ciała zapytania do strumienia.
connection.getOutputStream().write(jsonBody.getBytes("UTF-8"));
connection.setReadTimeout(5000);
connection.connect();

// 7. Odpowiedź po wykonaniu żądania.
if (connection.getResponseCode()==201)
    println("Issue has been created");
else if (connection.getErrorStream()!=null)
    println(connection.getErrorStream().getText());
    
// 8. Zamknięcie połączenia.
connection.disconnect();