// LISTING 18.1. Użycie basic authentification w połączeniu z Jira REST API

// 1. Dane użytkownika Jiry.
def userName = "username";
def password = "password";

// 2. URI endpointa Jira REST API.
def url = "http://172.16.117.141:8080/rest/api/2/issue/WT-4";

// 3. Zaszyfrowanie nazwy użytkownika i hasła za pomocą Base64.
def authString = ("${userName}:${password}").getBytes().encodeBase64().toString();

// 4. Otwarcie połączenia z endpointem.
def connection = url.toURL().openConnection() as HttpURLConnection;

// 5. Dodanie parametrów połączenia.
connection.addRequestProperty("Authorization", "Basic " + authString);
connection.addRequestProperty("Content-Type", "application/json");
connection.setRequestMethod("GET");
connection.setReadTimeout(5000)
connection.connect()

// 6. Wyświetlenie obiektu JSON w postaci String.
println(connection.getInputStream().getText("UTF-8"));

// 7. Zamknięcie połączenia.
connection.disconnect();