// LISTING 15.14. Pobieranie danych z projektu

import com.atlassian.jira.component.ComponentAccessor;

// 1. Pobranie menedżerów.
def projectManager = ComponentAccessor.getProjectManager();
def issueManager = ComponentAccessor.getIssueManager();

// 2. Pobranie obiektu typu interfejsowego Issue dowolnego zgłoszenia.
def issue = issueManager.getIssueObject("BP1-3");

// 3. Pobranie obiektu projektu po identyfikatorze.
def projectObject1 = projectManager.getProjectObj(10406);

// 4. Pobranie informacji o projekcie ze zgłoszenia.

// Pobranie obiektu zgłoszenia.
def projectObject2 = issue.getProjectObject();

// Pobranie klucza i ID obiektu ze zgłoszenia.
def projectObject2Id = issue.getProjectId();
def projectObject2Key = issue.getProjectObject().getKey();

// Pobranie szczegółów projektu.
def projectObject2Name = projectObject2.getName();
def projectObject2Description = projectObject2.getDescription();
def projectObject2Lead = projectObject2.getProjectLead();

// 5. Wyświetlenie wyników.
// projectObject2Id: 10406 | projectObject2Key: BP1 | projectObject2Name: Business
// project - Processing sth | projectObject2Description: | projectObject2Lead: jnowak
return "projectObject2Id: ${projectObject2Id} | projectObject2Key: ${projectObject2Key} | projectObject2Name: ${projectObject2Name} | projectObject2Description: ${projectObject2Description} | projectObject2Lead: ${projectObject2Lead.getName()}";