// LISTING 13.4. Tworzenie zgłoszenia z wypełnieniem podstawowych system fieldów

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.IssueInputParameters;
import java.time.temporal.WeekFields;
import java.time.DayOfWeek;

// 1. Pobranie obiektu typu interfejsowego ApplicationUser użytkownika admin.
def adminUser = ComponentAccessor.getUserManager().getUserByName("admin");

// 2. Pobranie obiektu użytkownika do Assignee w zależności od dnia tygodnia.

// Pobranie daty bieżącej.
def dateNow = new Date();

// Ustawienie poniedziałku jako pierwszego dnia tygodnia.
WeekFields weekFields = WeekFields.of(DayOfWeek.MONDAY, 1);

// Ustawienie użytkownika Assignee.
ApplicationUser assignee;
if (dateNow.toLocalDate().get(weekFields.dayOfWeek())<=2)
    assignee = ComponentAccessor.getUserManager().getUserByName("anowak");
else
    assignee = ComponentAccessor.getUserManager().getUserByName("jkowalski");

// 3. Pobranie komponentów IssueService i IssueInputParameters.
def issueService = ComponentAccessor.getIssueService();
IssueInputParameters inputParameters = issueService.newIssueInputParameters();

// 4. Uzupełnienie parametrów w obiekcie typu interfejsowego IssueInputParameters.
// projectId == 10200 => Zadania Cykliczne Działu Wsparcia.
// issueTypeId == 10001 => Story.
inputParameters
    .setProjectId(10200)
    .setIssueTypeId("10001")
    .setSummary("Przegląd kolejki zgłoszeń użytkowników - ${dateNow.getDateString()}")
    .setReporterId(adminUser.getName())
    .setAssigneeId(assignee.getName())
    .setDescription("1. Zaloguj się do Jiry.\n2. Przydziel nieprzypisane zgłoszenia do operatorów. \n3. Wyślij powiadomienia.");

// 5. Walidacja parametrów zgłoszenia za pomocą użytkownika admin.
def createValidationResult = issueService.validateCreate(adminUser, inputParameters);

// 6. Utworzenie zgłoszenia za pomocą użytkownika admin.
// Metoda create() zwraca obiekt IssueService.IssueResult.
def createIssueResult = issueService.create(adminUser, createValidationResult);

// 7. Możliwość pobrania obiektu typu interfejsowego Issue nowo utworzonego zgłoszenia.
// Osoby dodające wartości custom fieldów drugą metodą mają możliwość wykonania operacji na poniższym obiekcie.
def issue = createIssueResult.getIssue();